'use client'

import React from 'react'
import { motion } from 'framer-motion'
import DigitalMarketCard from '@/components/DigitalMarketCard'
import { IoIosArrowRoundDown } from "react-icons/io";
import ServerService from '@/components/ServerService'
import SmallPricing from '@/components/SmallPricing'
import { MoreAboutWebsiteDev, WebstieDevelopmentData, Pricing } from '@/constants/website';
import { CallsTypeData, TypesOfCalls } from '@/constants/callTypes';

type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={className}
        >
            {children}
        </motion.div>)
}
const CallTypes = () => {
    return (
        <div className='text-white overflow-hidden'>
            {/* hero section */}
            <div className='h-[90dvh] w-full flex flex-col justify-center items-center bg-black'>
                <div className='flex flex-col justify-center items-center'>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5 }}
                        className='w-fit'
                    >
                        <div className='text-5xl text-white font-bold'>Call Types</div>
                        <motion.div
                            initial={{ opacity: 0, width: 0 }}
                            whileInView={{ opacity: 1, width: '80%' }}
                            transition={{ duration: 0.5, delay: 0.6 }}
                            className='h-0.5 my-4 bg-gray-950 mx-auto'></motion.div>
                    </motion.div>
                    <TextAnimation>
                        <p className='w-4/5 lg:w-3/5 text-center text-lg mx-auto'>All-Calls Call Center Services provides customized solutions to our client’s and their customers..</p>
                    </TextAnimation>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.9 }}
                        className='py-4 mt-10'>
                        <div className='p-4 bg-gray-900/10 rounded-full border border-white/20'>
                            <IoIosArrowRoundDown className='text-4xl animate-bounce' />
                        </div>
                    </motion.div>
                </div>
            </div>

            {/* getting start */}
            <div className='h-[50dvh] flex justify-center items-center '>
                <div className='w-[90%] mx-auto flex flex-col justify-evenly lg:flex-row gap-4 py-8'>
                    <TextAnimation className='w-full lg:w-2/5'>
                        <div className='text-5xl'>
                            <p>Getting Started</p>
                            <p>with Calls</p>
                        </div>
                    </TextAnimation>
                    <TextAnimation className='w-full lg:w-3/5 text-lg lg:text-xl'>
                        <p>All-Calls Call Center Services provides American based agents for most contact types.
                            Whether you need inbound, outbound or blended agents, we have the program to meet your needs.</p>
                    </TextAnimation>
                </div>
            </div>

            {/* section 1 */}
            <div className='py-6'>
                {
                    CallsTypeData.map((data, i) =>
                        <DigitalMarketCard key={i} {...data} />
                    )
                }
            </div>

            {/* key steps in website development */}
            <div className='py-4'>
                <TextAnimation className='py-6'>
                    <p className='text-center text-4xl mx-auto py-4'>
                        Types of VoIP Routes
                    </p>
                </TextAnimation>
                <TextAnimation>
                    <p className='text-center w-4/5 mx-auto text-lg py-4'>Why do we need VoIP Route? It is because VoIP Routes are an integral part of the VoIP Telecommunication process and thereafter the VoIP industry as well. They are through which the VoIP calls pass and connect the caller and the receiver.
                    </p>
                </TextAnimation>

                {/* keys lists */}
                <div className='flex flex-col gap-6'>
                    {TypesOfCalls.map((type, i) =>
                        <DigitalMarketCard key={i} {...type} />
                    )}
                </div>
            </div>

            {/* server service */}
            <ServerService />

        </div>
    )
}

export default CallTypes