'use client'

import React from 'react'
import { motion } from 'framer-motion'
import { cn } from '@/lib/utils'
import { IoIosArrowRoundDown } from "react-icons/io";
import Link from 'next/link';
import { HiArrowLongRight } from 'react-icons/hi2';
import Image from 'next/image';
import ContactForm from '@/components/ContactForm';
type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={cn(className)}
        >
            {children}
        </motion.div>)
}

const Contact = () => {
    return (
        <div className='text-white'>
            <div className='h-[90dvh] w-full flex flex-col justify-center items-center bg-black'>
                <div className='flex flex-col justify-center items-center'>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5 }}
                        className='w-fit'
                    >
                        <div className='text-5xl text-white font-bold'>Contact Us</div>
                        <motion.div
                            initial={{ opacity: 0, width: 0 }}
                            whileInView={{ opacity: 1, width: '80%' }}
                            transition={{ duration: 0.5, delay: 0.6 }}
                            className='h-0.5 my-4 bg-gray-950 mx-auto'></motion.div>
                    </motion.div>
                    <TextAnimation>
                        <p className='w-4/5 lg:w-3/5 text-center text-lg mx-auto'>We are here to help and answer any question you might have. We look forward to hearing from you. Our support team will get back to you within 24 hours.</p>
                    </TextAnimation>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.9 }}
                        className='py-4 mt-10'>
                        <div className='p-4 bg-gray-900/10 rounded-full border border-white/20'>
                            <IoIosArrowRoundDown className='text-4xl animate-bounce' />
                        </div>
                    </motion.div>
                </div>
            </div>

            {/* section 2 */}
            <div className='min-h-[80dvh] w-[90%] mx-auto flex flex-col-reverse lg:grid lg:grid-cols-2 justify-items-center gap-6'>
                {/* Left section (Content) */}
                <div className='flex flex-col gap-6 px-6 py-4'>
                    <div className='flex flex-col gap-4'>
                        <motion.div
                            initial={{ opacity: 0, y: 100 }}
                            whileInView={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.5, delay: 0.3 }}
                            className='text-4xl font-semibold'
                        >
                            How Can We Help You?
                        </motion.div>
                        <motion.div
                            initial={{ opacity: 0, y: 100 }}
                            whileInView={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.5, delay: 0.5 }}
                            className='text-lg'
                        >
                            Please select a topic below related to your inquiry. If you don&#39;t find what you need, fill out our contact form.
                        </motion.div>
                    </div>

                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.7 }}
                        className='flex flex-col gap-6 py-4 border-b border-white/10'
                    >
                        <p className='text-lg'>
                            Request a demo from one of our conversion specialists.
                        </p>
                        <Link href="/contact" className='group w-fit py-2 px-6 flex flex-row items-center gap-2 bg-white/10 rounded-lg text-xl'>
                            Book a Demo <HiArrowLongRight className='group-hover:translate-x-2 transition-all duration-200' />
                        </Link>
                    </motion.div>

                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.9 }}
                        className='flex flex-col gap-6 py-4 border-b border-white/10'
                    >
                        <p className='text-lg'>
                            Discover the many ways in which our customers use VoIP Business.
                        </p>
                        <Link href="/contact" className='group w-fit py-2 px-6 flex flex-row items-center gap-2 bg-white/10 rounded-lg text-xl'>
                            Get Inspired <HiArrowLongRight className='group-hover:translate-x-2 transition-all duration-200' />
                        </Link>
                    </motion.div>

                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 1.1 }}
                        className='flex flex-col gap-6 py-4 border-b border-white/10'
                    >
                        <p className='text-lg'>
                            Join our Partner Program and earn 25% recurring commissions.
                        </p>
                        <Link href="/contact" className='group w-fit py-2 px-6 flex flex-row items-center gap-2 bg-white/10 rounded-lg text-xl'>
                            Become a Partner <HiArrowLongRight className='group-hover:translate-x-2 transition-all duration-200' />
                        </Link>
                    </motion.div>
                </div>

                {/* Right section (Image) */}
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.7 }}
                    className='w-full lg:w-4/5 flex justify-center items-baseline mx-auto py-4 px-8 lg:p-2 rounded-md overflow-hidden'
                >
                    <Image
                        src="/images/seo.jpg"
                        height={450}
                        width={650}
                        alt='img'
                        className='w-3/5 lg:w-4/5 rounded-lg hover:scale-105 transition-all duration-300'
                    />
                </motion.div>
            </div>


            {/* section 3 */}
            <div className="min-h-[90dvh] w-[90%] mx-auto grid grid-cols-1 lg:grid-cols-2 justify-items-center">
                {/* left section */}
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{
                        opacity: 1, y: 0,
                    }}
                    transition={{
                        duration: 0.7,
                    }
                    }
                    className='w-full lg:w-4/5 flex justify-center items-baseline mx-auto py-4 px-8 lg:p-2 rounded-md overflow-hidden'>
                    <Image src="/images/seo.jpg" height={450} width={650} alt='img' className='w-3/5 lg:w-4/5 rounded-lg hover:scale-105 transition-all duration-300' />
                </motion.div>
                {/* right section */}
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{
                        opacity: 1, y: 0,
                    }}
                    transition={{
                        duration: 0.9,
                    }}
                    className='w-full md:w-4/5'>
                    <ContactForm />
                </motion.div>
            </div>
        </div>
    )
}

export default Contact