'use client'

import React from 'react'
import { motion } from 'framer-motion'
import { DigitalMarketingData, FAQsData, TypesOfDigitalMarketing } from '@/constants/digitalMarketing'
import DigitalMarketCard from '@/components/DigitalMarketCard'
import { cn } from '@/lib/utils'
import { IoIosArrowDown, IoIosArrowRoundDown } from "react-icons/io";
import { HiArrowLongRight } from 'react-icons/hi2'
import Link from 'next/link'

type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={cn(className)}
        >
            {children}
        </motion.div>)
}

const DigitalMarketing = () => {
    return (
        <div className='text-white overflow-hidden'>
            <div className='h-[90dvh] w-full flex flex-col justify-center items-center bg-black'>
                <div className='flex flex-col justify-center items-center'>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5 }}
                        className='w-fit'
                    >
                        <div className='text-5xl text-white font-bold'>Digital Marketing</div>
                        <motion.div
                            initial={{ opacity: 0, width: 0 }}
                            whileInView={{ opacity: 1, width: '80%' }}
                            transition={{ duration: 0.5, delay: 0.6 }}
                            className='h-0.5 my-4 bg-gray-950 mx-auto'></motion.div>
                    </motion.div>
                    <TextAnimation>
                        <p className='w-4/5 lg:w-3/5 text-center text-lg mx-auto'>Basically, Digital Marketing refers to any online marketing efforts or assets. Email marketing, pay-per-click advertising, social media marketing and even blogging are all great examples of digital marketing.</p>
                    </TextAnimation>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.9 }}
                        className='py-4 mt-10'>
                        <div className='p-4 bg-gray-900/10 rounded-full border border-white/20'>
                            <IoIosArrowRoundDown className='text-4xl animate-bounce' />
                        </div>
                    </motion.div>
                </div>
            </div>
            <div className='h-[50dvh] flex justify-center items-center '>
                <div className='w-[90%] mx-auto flex flex-col justify-evenly lg:flex-row gap-4 py-8'>
                    <TextAnimation className='w-full lg:w-2/5'>
                        <div className='text-5xl'>
                            <p>Getting Started</p>
                            <p>with Digital Marketing</p>
                        </div>
                    </TextAnimation>
                    <TextAnimation className='w-full lg:w-3/5 text-lg lg:text-xl'>
                        <p>Basically, digital marketing refers to any online marketing efforts or assets. Email marketing, pay-per-click advertising, social media marketing and even blogging are all great examples of digital marketing.</p>
                    </TextAnimation>
                </div>
            </div>
            <div className='py-6'>
                {
                    DigitalMarketingData.map((data, i) =>
                        <DigitalMarketCard key={i} {...data} />
                    )
                }
            </div>

            {/* types of digital marketing */}
            <div className='py-4'>
                <TextAnimation className='py-6'>
                    <p className='text-center text-4xl py-4'>
                        Types of Digital Marketing
                    </p>
                </TextAnimation>
                <TextAnimation>
                    <p className='text-center text-lg py-4'>
                        The list of digital marketing strategies is also constantly evolving, but here are some of the strategies most businesses are using.
                    </p>
                </TextAnimation>
                <div className='flex flex-col gap-6'>
                    {TypesOfDigitalMarketing.map((type, i) =>
                        <DigitalMarketCard key={i} {...type} />
                    )}
                </div>
            </div>

            {/* faqs */}
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mx-auto p-4">
                {FAQsData.map((faq, i) => (
                    <motion.div
                        key={i}
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: i * 0.3 }}
                        className='relative w-full h-auto bg-white/5 rounded-md overflow-hidden'
                        style={{ gridRowEnd: `span ${Math.floor(Math.random() * 2) + 1}` }} // Vary height based on content
                    >
                        <div className='flex justify-between items-center text-2xl py-2 px-4'>
                            <span>{faq.title}</span>
                            <IoIosArrowDown />
                        </div>
                        <div className='px-4 text-gray-300'>
                            {faq.description.map((desc, i) => (
                                <div key={i} className='py-2'>
                                    {desc}
                                </div>
                            ))}
                        </div>
                    </motion.div>
                ))}
            </div>

            {/* server service */}
            <div className="h-[60dvh] w-full flex justify-center items-center">
                <div>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, }}
                        className='text-center text-4xl py-4'
                    >
                        Ready to get started
                    </motion.div>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.2 }}
                        className=''
                    >
                        More Server Bussiness features are coming your way
                    </motion.div>
                    <div className='flex flex-row justify-center items-center gap-4 py-6'>
                        <Link href='/about'>
                            <motion.div
                                initial={{ opacity: 0, y: 100 }}
                                whileInView={{ opacity: 1, y: 0 }}
                                transition={{ duration: 0.5, delay: 0.4 }}
                                className='group flex flex-row gap-2 justify-center items-center bg-green-400 px-4 py-2 text-lg text-gray-800 font-semibold rounded-lg'
                            >
                                View Features <HiArrowLongRight className='group-hover:translate-x-2 transition-all duration-200' />
                            </motion.div>
                        </Link>
                        <Link href="/contactus">
                            <motion.div
                                initial={{ opacity: 0, y: 100 }}
                                whileInView={{ opacity: 1, y: 0 }}
                                transition={{ duration: 0.5, delay: 0.7 }}
                                className='group flex flex-row gap-2 justify-center items-center bg-green-400 px-4 py-2 text-lg text-gray-800 font-semibold rounded-lg'
                            >
                                Join Now <HiArrowLongRight className='group-hover:translate-x-2 transition-all duration-200' />
                            </motion.div>
                        </Link>
                    </div>
                </div>

            </div>

        </div>
    )
}

export default DigitalMarketing