import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";
import Footer from "@/components/Footer";
import CursorFollower from "@/components/CursorFollower";
import BackToTop from "@/components/BackToTop";
import Navbar from "@/components/Navbar";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "Space Globaltele Services",
  description: "We take pride in delivering the latest technology and optimum quality solutions for the clients at affordable plans. In that process, we have maintained core concentration at security and productivity factors with VoIP (Voice over Internet Protocol), Toll Free Number & DID number and cloud technology. Being able to deliver on these stands successfully for more than a decade, our various clients have rated us as the best choice for business communications.",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body className={inter.className}>
        <CursorFollower />
        <Navbar />
        {children}
        <Footer />
        <BackToTop />
      </body>
    </html>
  );
}
