'use client'

import React, { memo, lazy, Suspense } from 'react'
import Feature from "@/components/home/Feature";
import Hero from "@/components/home/Hero";
import Pricing from "@/components/home/Pricing";
import Service from "@/components/home/Services";
import Technology from "@/components/home/Technology";

// const Service = lazy(() => import('@/components/home/Services'));
// const Hero = lazy(() => import('@/components/home/Hero'));
// const Pricing = lazy(() => import('@/components/home/Pricing'));
// const Feature = lazy(() => import('@/components/home/Feature'));
// const Technology = lazy(() => import('@/components/home/Technology'));
import { motion } from 'framer-motion'



const Home = () => {
  return (
    <>
      <Hero />
      <motion.div
        initial={{ width: 0 }}
        whileInView={{
          width: '80%',
          transition: {
            duration: 0.5
          }
        }}
        className="h-0.5 w-[80%] bg-slate-700 rounded-full mx-auto my-10"></motion.div>
      <Service />
      <Feature />
      <Suspense fallback={<div>Loading....</div>}>
        <Technology />
        <Pricing />
      </Suspense>
    </>
  );
}

export default memo(Home);