import DigitalMarketCard from '@/components/DigitalMarketCard'
import FAQs from '@/components/FAQs'
import Hero from '@/components/Hero'
import SubHero from '@/components/SubHero'
import VosPricing from '@/components/VosPricing'
import Worth from '@/components/Worth'
import { Price, Sippy, SippyFaqs, SippyWorth } from '@/constants/sippy'
import React from 'react'

const page = () => {
    return (
        <div className='text-white overflow-hidden'>
            <Hero title='Sippy Softswitch' subtitle='The most secure, scalable, flexible, and economic voice technology solutions delivered to global Mobile, MVNO, and Fixed Line Operators; Wholesalers, Call Centers, and Retail/Enterprise SIP solution providers.' />

            <SubHero title='High-Performance' subtitle='VoIP Solution' description='Sippyswitch solutions delivered to global Mobile, MVNO, and Fixed Line Operators, Wholesalers, Call Centers, and Retail/Enterprise SIP solution providers.' />


            <div>
                {
                    Sippy.map((data, i) =>
                        <DigitalMarketCard key={i} {...data} />
                    )
                }
            </div>

            {/* pricing */}
            <div className='w-screen'>
                <p className='text-4xl py-4 text-center font-semibold'>Pricing</p>
                <div className='w-full xl:w-4/5 mx-auto py-8 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 justify-items-center gap-4 px-2'>
                    {
                        Price.map((price, i) =>
                            <VosPricing key={i} {...price} />
                        )
                    }
                </div>
            </div>

            {/* faqs */}
            <FAQs data={SippyFaqs} />

            {/* worth */}
            <div className='w-full px-2 md:w-4/5 mx-auto pt-24'>
                <h3 className='text-2xl md:text-5xl py-5 text-center'>TOTALLY SERVED SIPPY TO CLIENT</h3>
                <p className='text-xl md:text-3xl py-2 text-center pt-6'>Why it&#x2019;s worth to choose SIPPY?</p>
                <p className='text-center text-sm md:text-lg pb-10'>Our successfully delivered services to give end-users where they get full of satisfied with us.
                </p>
                <div className='w-full md:w-4/5 grid grid-cols-1 gap-4 md:grid-cols-3 justify-items-center py-4 mx-auto'>

                    {
                        SippyWorth.map((worth, i) =>
                            <Worth key={i} {...worth} />)
                    }
                </div>
            </div>
        </div>
    )
}

export default page