'use client'

import React from 'react'
import { motion } from 'framer-motion'
import DigitalMarketCard from '@/components/DigitalMarketCard'
import { IoIosArrowRoundDown } from "react-icons/io";
import { KeyStepsSoftwareDev, Pricing, SoftwareDevelopmentData } from '@/constants/software'
import ServerService from '@/components/ServerService'
import SmallPricing from '@/components/SmallPricing'

type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={className}
        >
            {children}
        </motion.div>)
}

const SoftwareDevelopment = () => {
    return (
        <div className='text-white overflow-hidden'>
            {/* hero section */}
            <div className='h-[90dvh] w-full flex flex-col justify-center items-center bg-black'>
                <div className='flex flex-col justify-center items-center'>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5 }}
                        className='w-fit'
                    >
                        <div className='text-5xl text-white font-bold'>Software Development</div>
                        <motion.div
                            initial={{ opacity: 0, width: 0 }}
                            whileInView={{ opacity: 1, width: '80%' }}
                            transition={{ duration: 0.5, delay: 0.6 }}
                            className='h-0.5 my-4 bg-gray-950 mx-auto'></motion.div>
                    </motion.div>
                    <TextAnimation>
                        <p className='w-4/5 lg:w-3/5 text-center text-lg mx-auto'>Software development is the process of conceiving, specifying, designing, programming, documenting, testing, and bug fixing involved in creating and maintaining applications, frameworks, or other software components.</p>
                    </TextAnimation>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.9 }}
                        className='py-4 mt-10'>
                        <div className='p-4 bg-gray-900/10 rounded-full border border-white/20'>
                            <IoIosArrowRoundDown className='text-4xl animate-bounce' />
                        </div>
                    </motion.div>
                </div>
            </div>

            {/* getting start */}
            <div className='h-[50dvh] flex justify-center items-center '>
                <div className='w-[90%] mx-auto flex flex-col justify-evenly lg:flex-row gap-4 py-8'>
                    <TextAnimation className='w-full lg:w-2/5'>
                        <div className='text-5xl'>
                            <p>Getting Started</p>
                            <p>with Software Development</p>
                        </div>
                    </TextAnimation>
                    <TextAnimation className='w-full lg:w-3/5 text-lg lg:text-xl'>
                        <p>It is a process to create computer software using one or more specific programming languages that provides functionality to address particular business or personal objectives.</p>
                    </TextAnimation>
                </div>
            </div>

            {/* section 1 */}
            <div className='py-6'>
                {
                    SoftwareDevelopmentData.map((data, i) =>
                        <DigitalMarketCard key={i} {...data} />
                    )
                }
            </div>

            {/* key steps in software development */}
            <div className='py-4'>
                <TextAnimation className='py-6'>
                    <p className='text-center text-4xl py-4'>
                        Key steps in the software development process
                    </p>
                </TextAnimation>
                <TextAnimation>
                    <p className='text-center text-lg py-4'>
                        There are six major steps in the software development life cycle, including.
                    </p>
                </TextAnimation>

                {/* keys lists */}
                <div className='flex flex-col gap-6'>
                    {KeyStepsSoftwareDev.map((type, i) =>
                        <DigitalMarketCard key={i} {...type} />
                    )}
                </div>
            </div>

            {/* pricing */}
            <div className="w-[90%] min-h-[90dvh] grid grid-cols-1 lg:grid-cols-3 justify-items-center gap-4 mx-auto p-4">
                {Pricing.map((items, i) =>
                    <SmallPricing key={i} index={i} {...items} />
                )}
            </div>

            {/* server service */}
            <ServerService />

        </div>
    )
}

export default SoftwareDevelopment