import React from 'react'
import DigitalMarketCard from '@/components/DigitalMarketCard'
import { VosFAQs, VosOverview, VosPrice, VosWorth } from '@/constants/vos'
import ServerService from '@/components/ServerService'
import VosPricing from '@/components/VosPricing'
import FAQs from '@/components/FAQs'
import Hero from '@/components/Hero'
import SubHero from '@/components/SubHero'
import Worth from '@/components/Worth'


const VOS = () => {
    return (
        <div className='text-white overflow-hidden'>
            <Hero title="VOS3000" subtitle="Support 5,000 simultaneous calls with media for single server and handle 20,000 of accounts with online phones which have IVR, IP PBX, Media Sampling, Transcoding, Recoding, and many more." />

            <SubHero title='VOS3000 VoIP' subtitle='Operation Platform' description='VOS3000 softswitch supports SIP/H323/SIP-H323, with capacity up to 5,000 simultaneous calls which is 1,200 Calls Per Second' />
            <div className='py-4'>
                <div className='flex flex-col gap-6'>
                    {VosOverview.map((type, i) =>
                        <DigitalMarketCard key={i} {...type} />
                    )}
                </div>
            </div>

            {/* pricing */}
            <div className='w-screen'>
                <p className='text-4xl py-4 text-center font-semibold'>Pricing</p>
                <div className='w-full xl:w-4/5 mx-auto py-8 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 justify-items-center gap-4 px-2'>
                    {
                        VosPrice.map((price, i) =>
                            <VosPricing key={i} {...price} />
                        )
                    }
                </div>
            </div>

            {/* faqs */}
            <FAQs data={VosFAQs} />

            {/* worth */}
            <div className='w-full px-2 md:w-4/5 mx-auto pt-24'>
                <h3 className='text-2xl md:text-5xl py-5 text-center'>TOTALLY SERVED VOS3000 TO CLIENT</h3>
                <p className='text-xl md:text-3xl py-2 text-center pt-6'>Why it&#x2019;s worth to choose VPS / VOS?</p>
                <p className='text-center text-sm md:text-lg pb-10'>Our successfully delivered services to give end-users where they get full of satisfied with us.
                </p>
                <div className='w-full md:w-4/5 grid grid-cols-1 gap-4 md:grid-cols-3 justify-items-center py-4 mx-auto'>

                    {
                        VosWorth.map((worth, i) =>
                            <Worth key={i} {...worth} />)
                    }
                </div>
            </div>

            {/* server service */}
            <ServerService />

        </div>
    )
}

export default VOS