'use client'

import React from 'react'
import { motion } from 'framer-motion'
import DigitalMarketCard from '@/components/DigitalMarketCard'
import { cn } from '@/lib/utils'
import { IoIosArrowRoundDown } from "react-icons/io";
import { CloudServerFeatures, VpsBenefits } from '@/constants/vps'
import ServerService from '@/components/ServerService'

type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={cn(className)}
        >
            {children}
        </motion.div>)
}

const VPS = () => {
    return (
        <div className='text-white overflow-hidden'>
            <div className='h-[90dvh] w-full flex flex-col justify-center items-center bg-black'>
                <div className='flex flex-col justify-center items-center'>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5 }}
                        className='w-fit'
                    >
                        <div className='text-5xl text-white font-bold'>VPS HOSTING</div>
                        <motion.div
                            initial={{ opacity: 0, width: 0 }}
                            whileInView={{ opacity: 1, width: '80%' }}
                            transition={{ duration: 0.5, delay: 0.6 }}
                            className='h-0.5 my-4 bg-gray-950 mx-auto'></motion.div>
                    </motion.div>
                    <TextAnimation>
                        <p className='w-4/5 lg:w-3/5 text-center text-lg mx-auto'>VPS is the new way to ensure that your website runs at very high performance, including speed, privacy, hosting control, management, the ability to upgrade at will, and several other amazing benefits for your domain.</p>
                    </TextAnimation>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.9 }}
                        className='py-4 mt-10'>
                        <div className='p-4 bg-gray-900/10 rounded-full border border-white/20'>
                            <IoIosArrowRoundDown className='text-4xl animate-bounce' />
                        </div>
                    </motion.div>
                </div>
            </div>

            {/* section 2 */}
            <div className='py-4'>
                <div className='flex flex-col gap-6'>
                    {VpsBenefits.map((feature, i) =>
                        <DigitalMarketCard key={i} {...feature} />
                    )}
                </div>
            </div>

            {/*  */}
            <div className='py-4'>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5 }}
                    className='text-3xl text-center'>CLOUD SERVER FEATURES</motion.div>

                <div className='flex flex-col gap-6'>
                    {CloudServerFeatures.map((feature, i) =>
                        <DigitalMarketCard key={i} {...feature} />
                    )}
                </div>
            </div>

            {/* server service */}
            <ServerService />

        </div>
    )
}

export default VPS