'use client'

import React from 'react'
import { motion } from 'framer-motion'
import DigitalMarketCard from '@/components/DigitalMarketCard'
import { IoIosArrowRoundDown } from "react-icons/io";
import ServerService from '@/components/ServerService'
import SmallPricing from '@/components/SmallPricing'
import { MoreAboutWebsiteDev, WebstieDevelopmentData, Pricing } from '@/constants/website';

type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={className}
        >
            {children}
        </motion.div>)
}
const Website = () => {
    return (
        <div className='text-white overflow-hidden'>
            {/* hero section */}
            <div className='h-[90dvh] w-full flex flex-col justify-center items-center bg-black'>
                <div className='flex flex-col justify-center items-center'>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5 }}
                        className='w-fit'
                    >
                        <div className='text-5xl text-white font-bold'>Website Development</div>
                        <motion.div
                            initial={{ opacity: 0, width: 0 }}
                            whileInView={{ opacity: 1, width: '80%' }}
                            transition={{ duration: 0.5, delay: 0.6 }}
                            className='h-0.5 my-4 bg-gray-950 mx-auto'></motion.div>
                    </motion.div>
                    <TextAnimation>
                        <p className='w-4/5 lg:w-3/5 text-center text-lg mx-auto'>Web development is the work involved in developing a Web site for the Internet (World Wide Web) or an intranet (a private network). Web development can range from developing a simple single static page of plain text to complex web applications, electronic businesses, and social network services.</p>
                    </TextAnimation>
                    <motion.div
                        initial={{ opacity: 0, y: 100 }}
                        whileInView={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.5, delay: 0.9 }}
                        className='py-4 mt-10'>
                        <div className='p-4 bg-gray-900/10 rounded-full border border-white/20'>
                            <IoIosArrowRoundDown className='text-4xl animate-bounce' />
                        </div>
                    </motion.div>
                </div>
            </div>

            {/* getting start */}
            <div className='h-[50dvh] flex justify-center items-center '>
                <div className='w-[90%] mx-auto flex flex-col justify-evenly lg:flex-row gap-4 py-8'>
                    <TextAnimation className='w-full lg:w-2/5'>
                        <div className='text-5xl'>
                            <p>Getting Started</p>
                            <p>with Website Development</p>
                        </div>
                    </TextAnimation>
                    <TextAnimation className='w-full lg:w-3/5 text-lg lg:text-xl'>
                        <p>Looking for a beautiful, new website? You are at the right place! We deliver cutting edge websites that are beautiful to look at and perform equally well. Our web design services ensures a solid user experience that delivers substantially higher audience engagement and conversion rates.</p>
                    </TextAnimation>
                </div>
            </div>

            {/* section 1 */}
            <div className='py-6'>
                {
                    WebstieDevelopmentData.map((data, i) =>
                        <DigitalMarketCard key={i} {...data} />
                    )
                }
            </div>

            {/* key steps in website development */}
            <div className='py-4'>
                <TextAnimation className='py-6'>
                    <p className='text-center text-4xl py-4'>
                        More about Design
                    </p>
                </TextAnimation>

                {/* keys lists */}
                <div className='flex flex-col gap-6'>
                    {MoreAboutWebsiteDev.map((type, i) =>
                        <DigitalMarketCard key={i} {...type} />
                    )}
                </div>
            </div>

            {/* pricing */}
            <div className="w-[90%] min-h-[90dvh] grid grid-cols-1 lg:grid-cols-3 justify-items-center gap-4 mx-auto p-4">
                {Pricing.map((items, i) =>
                    <SmallPricing key={i} index={i} {...items} />
                )}
            </div>

            {/* server service */}
            <ServerService />

        </div>
    )
}

export default Website