'use client';

import React, { useEffect, useState } from 'react';
import BackToTopAnimation from '@/data/1727720678322.json';
import dynamic from 'next/dynamic';
import { motion } from 'framer-motion';

const Lottie = dynamic(() => import('lottie-react'), { ssr: false });

const BackToTop = () => {
    const [visible, setVisible] = useState(false);
    const [hovering, setHovering] = useState(false);

    useEffect(() => {
        const scroll = () => {
            const scrollPosition = window.scrollY;
            if (scrollPosition > 500) {
                setVisible(true);
            } else {
                setVisible(false);
                setHovering(false);
            }
        };
        window.addEventListener('scroll', scroll);
        return () => {
            window.removeEventListener('scroll', scroll);
        };
    }, []);

    const handleBackToTop = () => {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    };

    return (
        <>
            {visible && (
                <>
                    {hovering && (
                        <div className="fixed top-0 left-0 w-screen h-screen bg-black/30 backdrop-blur-sm z-[999]" />
                    )}

                    <motion.div
                        initial={{ opacity: 0, scale: 0 }}
                        animate={{ opacity: 1, scale: 1 }}
                        exit={{ opacity: 0, scale: 0 }}
                        transition={{ duration: 0.3, ease: 'easeInOut' }}
                        whileHover={{
                            scale: 1.1,
                            transition: { duration: 0.4, ease: 'easeInOut' },
                        }}
                        onHoverStart={() => setHovering(true)}
                        onHoverEnd={() => setHovering(false)}
                        className="fixed bg-black h-12 w-12 rounded-xl border right-6 bottom-6 hover:cursor-pointer z-[1000]"
                        onClick={handleBackToTop}
                    >
                        <Lottie animationData={BackToTopAnimation} loop={true} />
                    </motion.div>
                </>
            )}
        </>
    );
};

export default BackToTop;
