'use client'

import React, { useEffect, useState, useRef } from 'react';

const CursorFollower: React.FC = () => {
    const [position, setPosition] = useState({ x: 0, y: 0 });
    const [dotPosition, setDotPosition] = useState({ x: 0, y: 0 });

    const dotRef = useRef<HTMLDivElement>(null);

    useEffect(() => {
        const handleMouseMove = (event: MouseEvent) => {
            setPosition({ x: event.clientX, y: event.clientY });
        };

        window.addEventListener('mousemove', handleMouseMove);

        return () => {
            window.removeEventListener('mousemove', handleMouseMove);
        };
    }, []);

    // Smooth follow effect with easing
    useEffect(() => {
        let animationFrameId: number;

        const smoothFollow = () => {
            setDotPosition((prev) => {
                const dx = position.x - prev.x;
                const dy = position.y - prev.y;
                return {
                    x: prev.x + dx * 0.1,
                    y: prev.y + dy * 0.1,
                };
            });
            animationFrameId = requestAnimationFrame(smoothFollow);
        };

        smoothFollow();

        return () => {
            cancelAnimationFrame(animationFrameId);
        };
    }, [position]);

    return (
        <div style={{
            zIndex: 1000
        }}
            className='hidden sm:block'>
            <div
                ref={dotRef}
                style={{
                    position: 'fixed',
                    top: dotPosition.y,
                    left: dotPosition.x,
                    width: '30px',
                    height: '30px',
                    backgroundColor: 'white',
                    mixBlendMode: 'difference',
                    borderRadius: '50%',
                    pointerEvents: 'none',
                    transform: 'translate(-50%, -50%)',
                    transition: 'transform 0.1s ease',
                }}
            />
        </div>
    );
};

export default CursorFollower;
