'use client'

import React from 'react'
import Image from 'next/image';
import { motion } from 'framer-motion';
import { IoCheckmarkDoneSharp } from 'react-icons/io5';
import { cn } from '@/lib/utils';

type DigitalMarketingType = {
    id: number;
    imgSrc: string;
    title: string;
    description?: string[];
    featuresTitle?: string;
    featuresDescription?: string;
    features?: string[];
    bottomDescription?: string[];
}

const DigitalMarketCard = (props: DigitalMarketingType) => {

    const { id, imgSrc, title, description, featuresTitle, featuresDescription, features, bottomDescription } = props
    return (
        <div
            className={cn('min-h-[80vh] flex flex-col text-white py-12', id % 2 === 0 ? ' lg:flex-row' : ' lg:flex-row-reverse')}>
            {/* left section */}
            <motion.div
                initial={{ opacity: 0, x: 80 }}
                whileInView={{
                    opacity: 1,
                    x: 0,
                    transition: {
                        duration: 0.8,
                    }
                }}
                className='w-full lg:w-2/5 flex justify-center items-baseline mx-auto py-4 px-8 lg:p-2 rounded-md overflow-hidden'>
                <Image src={imgSrc} height={450} width={650} alt='img' className='w-3/5 lg:w-4/5 rounded-lg hover:scale-105 transition-all duration-300' />
            </motion.div>

            {/* right section */}
            <motion.div
                initial={{ opacity: 0, x: -80 }}
                whileInView={{
                    opacity: 1, x: 0, transition: {
                        duration: 0.8,
                        delay: 0.4
                    }
                }}
                className='w-4/5 lg:w-2/5 mx-auto'
            >
                <p className='text-4xl font-bold py-2'>{title}</p>
                <div className='py-2'>
                    {description?.map((desc, i) =>
                        <p key={i} className='italic my-4'>{desc}</p>
                    )}
                </div>

                {/* feature title */}
                {featuresTitle && (
                    <div className='text-lg font-semibold my-4'>{featuresTitle}</div>
                )
                }

                {/* feature description */}
                {featuresDescription && (
                    <div className='italic'>{featuresDescription}</div>
                )
                }

                {/* features */}
                {features && (
                    <div className='flex flex-col'>
                        {features?.map((feature, i) =>
                            <div key={i} className='flex flex-row gap-2 justify-start items-baseline my-2'> <IoCheckmarkDoneSharp className='text-green-400' /> {feature}</div>
                        )}
                    </div>)
                }

                {/* bottom description */}
                {bottomDescription && (
                    <div>
                        {bottomDescription?.map((desc, i) =>
                            <div key={i} className='italic my-4'>{desc}</div>
                        )}
                    </div>
                )
                }

            </motion.div>
        </div>
    )
}

export default DigitalMarketCard