'use client'

import React, { useState } from 'react';
import { IoIosArrowDown, IoIosArrowUp } from 'react-icons/io';
import { AnimatePresence, motion } from 'framer-motion'
import { FiMinus } from 'react-icons/fi';

type SEO_Tips = {
    index: number;
    title: string;
    description: string[];
    listItem?: string[];
}

const FAQAccordion = (props: SEO_Tips) => {
    const { index, title, description, listItem } = props;
    const [openIndex, setOpenIndex] = useState<number | null>(null);

    const toggleFAQ = (index: number) => {
        setOpenIndex(openIndex === index ? null : index);
    };

    return (
        <AnimatePresence>
            <motion.div
                initial={{ opacity: 0, y: 100 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.4, delay: 0.2, ease: "easeInOut" }}
                exit={{ opacity: 0, y: 100 }}
                className={`relative h-fit rounded-md overflow-hidden transition-all duration-500 bg-white/5 px-4 py-2`}
            >
                <div
                    className="flex justify-between items-center text-xl md:text-2xl py-2 px-4 cursor-pointer"
                    onClick={() => toggleFAQ(index)}
                >
                    <span>{title}</span>
                    {openIndex === index ? <IoIosArrowUp /> : <IoIosArrowDown />}
                </div>
                <motion.div
                    className="px-4 bg-white/5 text-gray-300 rounded-lg"
                    initial={{ height: 0, opacity: 0 }}
                    animate={{
                        height: openIndex === index ? 'auto' : 0,
                        opacity: openIndex === index ? 1 : 0
                    }}
                    transition={{ duration: 0.4, ease: "easeInOut" }}
                >
                    {description.map((desc, i) => (
                        <div key={i} className="py-2">
                            {desc}
                        </div>
                    ))}
                    {listItem && listItem.map((item, i) =>
                        <div key={i} className="py-2">
                            <ul className="ml-2">
                                <li className='flex items-center gap-2'><FiMinus /> {item}</li>
                            </ul>
                        </div>
                    )}
                </motion.div>
            </motion.div>
        </AnimatePresence>
    );
};

export default FAQAccordion;
