import React from 'react'
import FAQAccordion from './FAQAccordian'

type DataType = {
  title: string;
  description: string[];
}

const FAQs = ({ data }: { data: DataType[] }) => {
  return (
    <div className="w-full md:w-4/5 min-h-[50dvh] grid grid-cols-1 lg:grid-cols-2 justify-items-center gap-4 mx-auto pt-8 md:p-4 ">
      {data.map((props, i) => (
        <FAQAccordion key={i} index={i} {...props} />
      ))}
    </div>
  )
}

export default FAQs