import React, { ReactNode } from 'react'
import { motion } from 'framer-motion'

type FeatureCardType = {
    index: number;
    logo: ReactNode,
    title: string,
    description?: string,
    className?: string,
    iconStyle?: string
}

const FeatureCard = ({ index, logo, title, description, className, iconStyle }: FeatureCardType) => {

    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{
                opacity: 1, y: 0,
                transition: {
                    duration: 0.5,
                    delay: index * 0.3
                },
            }}
            className={`relative w-[90%] flex flex-row gap-4 text-white px-4 py-4 mx-auto transition-all ease-out duration-300 ${className}`}>
            <div className={`text-5xl ${iconStyle}`}>{logo}</div>
            <div className='flex flex-col gap-2'>
                <div className='text-2xl font-bold text-gray-300'>{title}</div>
                <div className='text-gray-500'>{description}</div>
            </div>
            <div className='absolute top-0 left-0 w-full h-full bg-white opacity-5 rounded-md hover:border hover:border-gray-900'></div>
        </motion.div>
    )
}

export default FeatureCard