'use client'

import React from 'react'
import Goto from './Goto'
import { motion } from 'framer-motion'

const Footer = () => {

    return (
        <div className='relative w-full px-4 pt-20'>
            <motion.div
                initial={{
                    opacity: 0,
                    rotateX: 10
                }}
                whileInView={
                    {
                        opacity: 1,
                        rotateX: 0,
                        transition: {
                            duration: 0.6
                        }
                    }
                }
                className='w-full text-white flex flex-col lg:flex-row justify-between'>
                {/* left side */}
                <div className='w-full lg:w-2/6 px-4 py-4 flex flex-col justify-between gap-16'>
                    <div className='text-white text-center text-[6dvw] lg:text-left lg:text-[4dvw] tracking-tight py-4 leading-none'>Nothing gets in the way of our client&#39; vision</div>
                    <div>
                        <p className='text-gray-400'>Email</p>
                        <p>sales@spaceglobalservices.com</p>
                        <p>support@spaceglobalservices.com
                        </p>
                    </div>
                </div>


                {/* middle */}
                <div className='w-full lg:w-2/6 flex flex-row justify-around py-4'>
                    <div className='flex flex-col gap-2 text-sm'>
                        <Goto title='HOME' href="/" />
                        <Goto title='DIGITAL MARKETING' href='/digitalmarketing' />
                        <Goto title='SEO' href='/seo' />
                        <Goto title='SOFTWARE DEVELOPMENT' href='/software' />
                        <Goto title='WEB DEVELOPMENT' href='/website' />
                    </div>
                    <div className='flex flex-col pl-4'>
                        <p className='px-4 text-gray-400'>SERVICES</p>
                        <Goto title='› VPS' href='/digitalmarketing' />
                        <Goto title='› VOS' href='/digitalmarketing' />
                        <Goto title='› SIPPY' href='/digitalmarketing' />
                        <Goto title='› PBX' href='/digitalmarketing' />
                        <Goto title='› ASTRISK' href='/digitalmarketing' />
                    </div>

                </div>
                {/* right side */}
                <div className='flex flex-col gap-6 py-4'>
                    {/* row 1 */}
                    <div className='bg-white w-full h-44 px-8 flex flex-col gap-4 text-center justify-center items-center mx-auto text-black rounded-md'>
                        <p className='text-xl'>Interested in working together?</p>
                        <Goto title='sales@spaceglobalservices.com' href='/' className='bg-black text-white hover:bg-gray-900 hover:text-white' />
                    </div>
                    {/* row 2 */}
                    <div className='flex flex-row justify-between items-start'>
                        <div className='flex flex-col'>
                            <p className='text-sm text-gray-400'>Socials</p>
                            <Goto title='Facebook' href='/' />
                            <Goto title='Instagram' href='/' />
                            <Goto title='Twitter' href='/' />
                        </div>
                        <div className='flex flex-col'>
                            <p className='text-sm text-gray-400'>Links</p>
                            <Goto title='› About Us' href='aboutus' />
                            <Goto title='› Contact Us' href='contact' />
                            <Goto title='› Terms of service' href='termsofservice' />
                        </div>
                    </div>

                    {/* row 3 */}
                    <div className='text-gray-100'>
                        <p className='text-sm py-2 text-gray-400'>Address</p>
                        <p>1201 Race Course Rd ,</p>
                        <p>#06-09 ,</p>
                        <p>Singapore 218612</p>
                        <p>Phone: +65 6002 8001</p>
                        <p></p>
                    </div>
                </div>
            </motion.div>

            {/* divider */}
            <div className='mx-auto w-4/5 bg-gray-950 my-8 h-0.5 rounded-full'></div>

            <motion.div
                initial={{
                    opacity: 0,
                    y: 10
                }}
                whileInView={{
                    opacity: 1,
                    transition: {
                        duration: 0.6
                    },
                    y: 0
                }}
                className='text-[7dvw] h-fit text-white text-center'>Space Globaltele Services</motion.div>
            {/* copyrights */}
            <motion.div
                initial={{
                    opacity: 0,
                    y: 15
                }}
                whileInView={{
                    opacity: 1,
                    transition: {
                        duration: 0.6,
                        delay: 0.3
                    },
                    y: 0
                }}
                className='w-full py-2'>
                <p className='text-sm text-center text-gray-700'>©️ Copyright Space Global Services. All right reserved.</p>
            </motion.div>


        </div>
    )
}

export default Footer