import { cn } from '@/lib/utils';
import Link from 'next/link';
import React from 'react'

type GotoTypes = {
    href: string;
    title: string;
    className?: string;
}

const Goto = ({ title, href, className }: GotoTypes) => {
    return (
        <Link href={href} className={cn("w-fit px-4 py-2 hover:bg-gray-50/10 rounded-md", className)}>{title}</Link>
    )
}

export default Goto