'use client'

import React from 'react'
import { motion } from 'framer-motion'
import { cn } from '@/lib/utils';
import { IoIosArrowRoundDown } from 'react-icons/io';

type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={cn(className)}
        >
            {children}
        </motion.div>)
}

const Hero = ({ title, subtitle }: { title: string, subtitle: string }) => {
    return (
        <div className='h-[100dvh] w-full flex flex-col justify-center items-center bg-black'>
            <div className='flex flex-col justify-center items-center'>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5 }}
                    className='w-fit'
                >
                    <div className='text-5xl text-center text-white font-bold'>{title}</div>
                    <motion.div
                        initial={{ opacity: 0, width: 0 }}
                        whileInView={{ opacity: 1, width: '80%' }}
                        transition={{ duration: 0.5, delay: 0.6 }}
                        className='h-0.5 my-4 bg-gray-950 mx-auto'></motion.div>
                </motion.div>
                <TextAnimation>
                    <p className='w-4/5 lg:w-3/5 text-center text-lg mx-auto'>{subtitle}</p>
                </TextAnimation>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5, delay: 0.9 }}
                    className='py-4 mt-10'>
                    <div className='p-4 bg-gray-900/10 rounded-full border border-white/20'>
                        <IoIosArrowRoundDown className='text-4xl animate-bounce' />
                    </div>
                </motion.div>
            </div>
        </div>
    )
}

export default Hero