import React from 'react'
import { HoverBorderGradient } from './ui/hover-border-gradient'

const HoverButton = ({ title, containerClassName, className }: { title: string, containerClassName?: string, className?: string }) => {
    return (
        <HoverBorderGradient
            containerClassName={`rounded-md ${containerClassName}`}
            as="button"
            className={`bg-white text-black flex items-center space-x-2 ${className}`}
        >
            <span>{title}</span>
        </HoverBorderGradient>
    )
}

export default HoverButton