'use client'

import React, { useState } from 'react';
import { HoveredLink, Menu, MenuItem } from './ui/navbar-menu';
import { FloatingNav } from './ui';
import { FaBars } from 'react-icons/fa';
import { cn } from '@/lib/utils';

const Navbar = () => {
    const [active, setActive] = useState<string | null>(null);
    const [menuOpen, setMenuOpen] = useState(false); // State to manage menu toggle

    const toggleMenu = () => {
        setMenuOpen(!menuOpen);
        console.log('clicked') // Toggle menu visibility
    };

    const handleMenuItemClick = (itemKey: string) => {
        if (active === itemKey) {
            setActive(null); // Close the active menu if clicked again
        } else {
            setActive(itemKey); // Open the selected menu
        }
    };

    return (
        <FloatingNav>
            <Menu setActive={setActive} setMenuOpen={setMenuOpen}>
                {/* Mobile menu */}
                <div className={cn("flex w-fit mx-auto lg:hidden items-center gap-2")} onClick={toggleMenu}>
                    <FaBars /> Menu
                </div>

                {/* Desktop menu */}
                <div className={`lg:flex lg:flex-row gap-4 ${menuOpen ? 'grid grid-cols-1 py-6 px-4 items-center mx-auto' : 'hidden'}`}>
                    <HoveredLink href="/">⌂ Home</HoveredLink>
                    <HoveredLink href="/digitalmarketing">ↇ Digital Marketing</HoveredLink>
                    <HoveredLink href="/seo">◎ SEO</HoveredLink>

                    {/* Development menu item */}
                    <MenuItem
                        setActive={() => handleMenuItemClick('development')}
                        active={active}
                        itemKey="development"
                        item="Development ⇃"
                    >
                        <div className="flex flex-col space-y-4 text-sm">
                            <HoveredLink href="/software">Software Development</HoveredLink>
                            <HoveredLink href="/website">Web Development</HoveredLink>
                        </div>
                    </MenuItem>

                    {/* Call Types menu item */}
                    <MenuItem
                        setActive={() => handleMenuItemClick('callTypes')}
                        active={active}
                        itemKey="callTypes"
                        item="Call Types ⇃"
                    >
                        <div className="grid grid-cols-2 gap-6 text-sm px-4">
                            <div className="flex flex-col gap-2">
                                <p className="text-gray-500 text-xs">Call Traffic Types</p>
                                <HoveredLink href="/calltypes">CLI Route</HoveredLink>
                                <HoveredLink href="/calltypes">Non-CLI Route</HoveredLink>
                                <HoveredLink href="/calltypes">Direct Route</HoveredLink>
                                <HoveredLink href="/calltypes">TDM</HoveredLink>
                                <HoveredLink href="/calltypes">PRI</HoveredLink>
                            </div>
                            <div className="flex flex-col gap-2">
                                <p className="text-gray-500 text-xs">Traffic Profile</p>
                                <HoveredLink href="/calltypes">Outbound Calls</HoveredLink>
                                <HoveredLink href="/calltypes">Press 1 Calls</HoveredLink>
                            </div>
                        </div>
                    </MenuItem>

                    {/* Services menu item */}
                    <MenuItem
                        setActive={() => handleMenuItemClick('services')}
                        active={active}
                        itemKey="services"
                        item="Services ⇃"
                    >
                        <div className="flex flex-col space-y-4 text-sm">
                            <HoveredLink href="/vps">VPS</HoveredLink>
                            <HoveredLink href="/vos">VOS</HoveredLink>
                            <HoveredLink href="/sippy">SIPPY</HoveredLink>
                            <HoveredLink href="/pbx">PBX</HoveredLink>
                            <HoveredLink href="/astrisk">Astrisk</HoveredLink>
                            <HoveredLink href="/calltypes">Vicidial</HoveredLink>
                        </div>
                    </MenuItem>

                    <HoveredLink href="/contact">◧ Contact</HoveredLink>
                </div>
            </Menu>
        </FloatingNav >
    );
};

export default Navbar;
