import React from 'react'
import { CardSpotlight } from './ui/card-spotlight';
import Link from 'next/link';
import { MdKeyboardArrowRight } from "react-icons/md";
import { motion } from 'framer-motion'

type PricingType = {
    index: number;
    type: string;
    price: string;
    description: string;
    features: string[];
    button: string;
    buttonLink: string
}

const FeatureList = ({ feature }: { feature: string }) => {
    return (
        <div className='flex flex-row gap-2 justify-start items-center'>
            <MdKeyboardArrowRight /> {feature}
        </div>
    )
}

const PricingCard = ({ index, type, price, description, features, button, buttonLink }: PricingType) => {

    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{
                opacity: 1, y: 0,
                transition: {
                    duration: 0.5,
                    delay: index * 0.3
                },
            }}
        >
            <CardSpotlight className="inline-block w-[350px] mx-auto gap-4">
                <p className="text-4xl text-center font-bold relative z-20 mt-2 text-white pb-4">
                    {type}
                </p>
                <div className="h-60 w-full flex flex-col gap-2 justify-center items-center text-neutral-200 relative z-20 bg-black/20 hover:bg-black/10 rounded-lg ">
                    <p className='flex flex-row gap-1'>
                        <span className='text-5xl'>
                            {price}
                        </span>
                        <span>
                            /year
                        </span>
                    </p>
                    <p className='text-sm'>{description}</p>
                </div>
                <div className="flex flex-col gap-4 text-neutral-200 mt-4 relative z-20">
                    {features.map((feature, i) =>
                        <FeatureList key={i} feature={feature} />
                    )}
                </div>
                <div className='z-20 flex pt-6'>
                    <Link href={buttonLink} className="px-6 py-3 mx-auto border border-white/50 text-neutral-200 bg-black/60 rounded-md relative z-20 hover:bg-black/40">
                        {button}
                    </Link>
                </div>
            </CardSpotlight>
        </motion.div>
    )
}


export default PricingCard