'use client'

import React from 'react'
import Link from 'next/link'
import { motion } from 'framer-motion'
import { HiArrowLongRight } from 'react-icons/hi2'

const ServerService = () => {
    return (
        <div className="h-[60dvh] w-full flex flex-col justify-center items-center">
            <div>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5, }}
                    className='text-center text-4xl py-4'
                >
                    Ready to get started
                </motion.div>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5, delay: 0.1 }}
                    className=''
                >
                    More Server Bussiness features are coming your way
                </motion.div>
                <div className='flex flex-row justify-center items-center gap-4 py-6'>
                    <Link href='/about'>
                        <motion.div
                            initial={{ opacity: 0, y: 100 }}
                            whileInView={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.5, delay: 0.2 }}
                            className='group flex flex-row gap-2 justify-center items-center bg-green-400 px-4 py-2 text-lg text-gray-800 font-semibold rounded-lg'
                        >
                            View Features <HiArrowLongRight className='group-hover:translate-x-2 transition-all duration-200' />
                        </motion.div>
                    </Link>
                    <Link href="/contactus">
                        <motion.div
                            initial={{ opacity: 0, y: 100 }}
                            whileInView={{ opacity: 1, y: 0 }}
                            transition={{ duration: 0.5, delay: 0.3 }}
                            className='group flex flex-row gap-2 justify-center items-center bg-green-400 px-4 py-2 text-lg text-gray-800 font-semibold rounded-lg'
                        >
                            Join Now <HiArrowLongRight className='group-hover:translate-x-2 transition-all duration-200' />
                        </motion.div>
                    </Link>
                </div>
            </div>

            <div>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5, delay: 0.3 }}
                    className='text-center text-3xl py-4'>Subscribe Our Newsletter</motion.div>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5, delay: 0.4 }}
                    className="flex flex-row h-10 justify-center items-center rounded-lg">
                    <input type="email" placeholder="Enter your email" className="bg-white h-full w-4/5 rounded-l-lg focus:outline-none text-black px-2" />
                    <Link href="#"
                        className='h-full flex flex-row gap-2 justify-center items-center bg-green-400 px-4 py-1 text-lg text-gray-800 font-semibold rounded-r-lg'
                    >
                        Subscribe
                    </Link>
                </motion.div>
            </div>
        </div>
    )
}

export default ServerService