import React from 'react'
import { motion } from 'framer-motion'
import Link from 'next/link';

type SmallPricingType = {
    index: number;
    title: string;
    price: number;
    description?: string[];
    featuresList: {
        feature: string;
        available: boolean;
    }[];
};


const SmallPricing = (props: SmallPricingType) => {
    const { index, title, price, description, featuresList } = props
    return (
        <motion.div
            animate={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: index * 0.2 }}
            className='w-4/5 min-h-4/5 lg:w-4/5 flex flex-col justify-between items-center py-8 bg-white/5 rounded-md hover:shadow-md hover:shadow-white/10'
        >
            <div className="text-4xl py-4">{title}</div>
            <div className="py-8">
                <span className='text-5xl '>{price}</span>
                <span>-/ Year</span>
            </div>
            {
                description && <div>
                    {
                        description.map((desc, i) =>
                            <div key={i}>{desc}</div>
                        )
                    }
                </div>
            }
            <div className='flex flex-col gap-2 py-4'>
                {featuresList.map((item, i) =>
                    <div key={i} className='text-center'>
                        {item.available ? <p className=''>{item.feature}</p> : <p className='stroke-current'>{item.feature}</p>}
                    </div>
                )}
            </div>
            <div className=''>
                <Link href="/" className='px-4 py-2 bg-white/20 text-xl font-semibold rounded-md'>BUY NOW</Link>
            </div>
        </motion.div>
    )
}

export default SmallPricing