'use client'

import React from 'react'
import { motion } from 'framer-motion'
import { cn } from '@/lib/utils';

type TextAnimationType = {
    className?: string;
    children: React.ReactElement
}
const TextAnimation = ({ className, children }: TextAnimationType) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.5, delay: 0.5 }}
            className={cn(className)}
        >
            {children}
        </motion.div>)
}
const SubHero = ({ title, subtitle, description }: { title: string, subtitle: string, description: string }) => {
    return (
        <div className='h-[40dvh] flex justify-center items-center'>
            <div className='w-[90%] mx-auto flex flex-col justify-evenly lg:flex-row gap-4 py-8'>
                <TextAnimation className='w-full lg:w-2/5'>
                    <div className='text-5xl'>
                        <p>{title}</p>
                        <p>{subtitle}</p>
                    </div>
                </TextAnimation>
                <motion.div
                    initial={{ opacity: 0, y: 100 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5, delay: 1 }}
                    className='w-full lg:w-3/5 text-lg lg:text-xl'>
                    <p>{description}</p>
                </motion.div>
            </div>
        </div>
    )
}

export default SubHero