'use client'

import { cn } from '@/lib/utils'
import Link from 'next/link'
import React, { ReactNode } from 'react'
type VosPricingType = {
    id: number
    icon: React.ReactNode,
    core: string,
    cpu: string,
    price: string,
    features: string[],
    buttonTitle: string,
    buttonLink: string,
}
import { motion } from 'framer-motion'


const SimpleAnimationBg = ({ children, id, className }: { children: ReactNode, id: number, className?: string }) => {
    return (
        <motion.div
            initial={{ opacity: 0, y: 100 }}
            animate={{ opacity: 1, y: 0, transition: { duration: 0.2, delay: id * 0.2, ease: 'linear', } }}
            className={cn("min-h-[80dvh] w-full sm:w-[90%] bg-gradient-to-r rounded-lg shadow-md relative")}>
            <div className="absolute inset-0 flex flex-wrap items-center justify-center gap-4"
            >
                {Array.from({ length: 1 }).map((_, index) => (
                    <motion.div
                        key={index}
                        className="relative w-40 h-40 m-4 bg-purple-600"
                        animate={{
                            borderRadius: [
                                '90% 30% 73% 44%',
                                '70% 80% 96% 80%',
                                '88% 94% 76% 73%',
                            ],
                            translateX: [0, 30, -20],
                            translateY: [0, 30, -20],
                            scale: [1, 1.5, 1],
                            backgroundColor: ['#ff006e', '#3a86ff', '#8338ec'],
                        }}
                        transition={{
                            duration: 6,
                            times: [0, 0.5, 1],
                            repeat: Infinity,
                            repeatType: 'mirror',
                            ease: 'easeInOut',
                        }}
                    />
                ))}
            </div>
            <div className={cn("absolute h-full inset-0 flex flex-col items-center justify-center backdrop-blur-lg bg-white bg-opacity-5 rounded-xl z-10 space-y-2 mb-4 text-center", className)}>
                {children}
            </div>
        </motion.div>
    );
};


const VosPricing = ({ id, icon, core, cpu, price, features, buttonTitle, buttonLink }: VosPricingType) => {

    return (
        <SimpleAnimationBg id={id}>
            <div className='py-4 flex flex-col items-center'>
                <div className="text-4xl text-green-400">{icon}</div>
                <div className="text-sm">{core}</div>
                <div className="text-xl font-bold text-green-500">{cpu}</div>
                <div className="h-28 w-28 bg-white/10 mx-auto flex justify-center items-center rounded-full my-4">
                    <span className=''>$</span>
                    <span className='text-5xl font-semibold'>{price}</span>
                </div>
            </div>
            <div className="flex flex-col space-y-2 mb-4">
                {features.map((feature, i) => (
                    <div key={i} className="py-1 text-sm text-pink-100">
                        {feature}
                    </div>
                ))}
            </div>
            <div className="flex justify-center py-4">
                <Link href={buttonLink} className="bg-black border border-white text-white px-10 py-2 rounded-full shadow hover:bg-gray-100 transition duration-300">
                    {buttonTitle}

                </Link>
            </div>
        </SimpleAnimationBg>
    )
}

export default VosPricing