'use client'

import React, { ReactNode } from 'react'
import { motion } from 'framer-motion'

type WorthType = {
    id: number,
    icon: ReactNode,
    number: string,
    content: string
}
const Worth = (props: WorthType) => (
    <motion.div
        initial={{ opacity: 0, y: 100 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.5, delay: props.id * 0.1 }}
        className='bg-white/10 w-56 py-10 px-6 rounded-xl text-center flex flex-col justify-center items-center'>
        <div className='text-4xl pb-4 text-green-400'>{props.icon}</div>
        <div className='text-5xl'>{props.number}</div>
        <div className='text-sm py-2'>{props.content}</div>
    </motion.div>
)

export default Worth