'use client'

import { lazy, memo } from 'react';
import { features } from '@/lib/constant';
import { HeroHighlight } from '@/components/ui/index';
import { motion } from 'framer-motion'

const FeatureCard = lazy(() => import('@/components/FeatureCard'));
const Feature = () => {
    return (
        <HeroHighlight className="w-full py-10 relative">
            <div className="mb-14 text-center">
                <motion.div
                    initial={{ opacity: 0, y: 50 }}
                    whileInView={{
                        opacity: 1, y: 0,
                        transition: {
                            duration: 0.5,
                        },
                    }}
                    className="text-3xl font-bold text-white">Our Features</motion.div>
                <motion.div
                    initial={{ opacity: 0, y: 50 }}
                    whileInView={{
                        opacity: 1, y: 0,
                        transition: {
                            duration: 0.5,
                            delay: 0.3
                        },
                    }}
                    className="text-white">We’re faster and cheaper than the rest</motion.div>
            </div>
            <div className="w-full lg:w-4/5 px-6 grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-4 justify-items-center mx-auto relative">

                {features.map((val, i) => (
                    <FeatureCard
                        index={i}
                        key={i}
                        title={val.title}
                        description={val.description}
                        logo={val.logo}
                        className="hover:scale-110"
                    />
                ))}
            </div>
        </HeroHighlight>
    )
}

export default memo(Feature)