'use client'

import React, { Suspense, lazy, memo } from 'react';
import { HoverButton } from '@/components/index';
import {
    ShootingStars,
    StarsBackground,
} from '@/components/ui/index';
import { motion } from 'framer-motion'

// Lazy load large components
const Globe = lazy(() => import('@/components/Globe'));

const Hero = () => {
    return (
        <motion.div
            initial={{ opacity: 0 }}
            whileInView={{ opacity: 1 }}
            className="relative w-full flex flex-col lg:flex-row items-center justify-center h-screen">
            <ShootingStars />
            <StarsBackground />
            <div className="absolute xl:relative flex flex-col justify-center items-center text-center z-10 xl:w-1/2 p-5">
                <motion.div
                    initial={{
                        opacity: 0, y: 50
                    }}
                    animate={{
                        opacity: 1,
                        y: 0
                    }}
                    transition={{
                        duration: 0.8,
                    }}
                    className="text-[10dvw] md:text-[7vdw] xl:text-[5dvw] font-bold text-white">
                    Better Server Experience With
                </motion.div>
                <motion.div
                    initial={{
                        opacity: 0, y: 50
                    }}
                    animate={{
                        opacity: 1,
                        y: 0
                    }}
                    transition={{
                        duration: 0.8,
                        delay: 0.5
                    }}
                    className="text-[3dvw] lg:text-[2dvw] font-normal text-neutral-700 dark:text-neutral-200 mt-2 pb-4 max-w-md">
                    Space Global Services
                </motion.div>
                <motion.div
                    initial={{
                        opacity: 0, y: 50
                    }}
                    animate={{
                        opacity: 1,
                        y: 0
                    }}
                    transition={{
                        duration: 0.8,
                        delay: 1
                    }}
                >
                    <HoverButton title="Get Started"
                        className="text-xl" containerClassName="rounded-full mt-4" />
                </motion.div>
            </div>
            <div className="w-full lg:w-[100%] xl:w-[50%] flex justify-center items-center pt-10">
                <Suspense fallback={<div className='text-white'>Loading...</div>}>
                    <Globe />
                </Suspense>
            </div>
        </motion.div>
    )
}

export default memo(Hero)