'use client'

import React, { memo, Suspense } from 'react';

import { WavyBackground } from '@/components/ui/index';
import { motion } from 'framer-motion'
import { PricingData } from '@/constants/pricing';
import { PricingCard } from '@/components/index';


const Pricing = () => {
    return (
        <motion.div
            className="relative w-full min-h-screen text-white overflow-x-hidden"
            initial={{ opacity: 0 }}
            whileInView={{ opacity: 1 }}
        >
            {/* <div className="text-center text-white py-4">
                <h2 className="text-5xl font-bold text-green-400">Pricing</h2>
                <h3 className="text-md font-bold">Choose your need by means necessary</h3>
            </div> */}
            <WavyBackground className="w-full h-full p-4 flex flex-col">
                <div className="min-h-[70dvh] w-full flex justify-center items-center">
                    <div className="min-h-[70dvh] w-full lg:w-4/5 px-2 overflow-x-auto overflow-y-hidden whitespace-nowrap flex gap-4 lg:justify-center">
                        {PricingData.map((val, i) => (
                            <PricingCard
                                key={i}
                                index={i}
                                type={val.type}
                                price={val.price}
                                description={val.description}
                                features={val.features}
                                button={val.button}
                                buttonLink={val.buttonLink}
                            />
                        ))}
                    </div>
                </div>
            </WavyBackground>
        </motion.div>
    )
}

export default memo(Pricing)