'use client'

import React, { memo } from 'react';
import { HoverButton } from '@/components/index';
import { GlareCard } from '@/components/ui/index';

const MemoizedGlareCard = memo(({ title, description }: { title: string, description: string }) => (
    <GlareCard className="flex flex-col gap-4 items-center justify-center px-8 mx-auto">
        <h2 className="text-3xl font-bold text-white">{title}</h2>
        <p className="text-white">{description}</p>
        <HoverButton title="View Services" containerClassName="rounded-md mt-10" />
    </GlareCard>
));
MemoizedGlareCard.displayName = "MemoizedGlareCard";
const Service = () => {
    return (
        <div className="w-full min-h-[90vh] mx-auto flex justify-center items-center">
            <div
                className="w-4/5 mx-auto grid grid-cols-1 lg:grid-cols-3 gap-2 items-center justify-items-center"
            >
                {['Service 1', 'Service 2', 'Service 3'].map((service, i) => (
                    <div key={i} className='mx-auto' >
                        <MemoizedGlareCard
                            title="The best provider networking"
                            description="Aliquam vulputate, tortor nec commodo ultricies, vitae viverra urna architecto beatae vitae dicta sunt explicabo."
                        />
                    </div>
                ))}
            </div>
        </div>
    )
}

export default memo(Service)