'use client'

import React, { memo } from 'react';
import { technology } from '@/lib/constant';
import { FeatureCard } from '@/components/index';
import { DirectionAwareHover } from '@/components/ui/index';
import { motion } from 'framer-motion'

const Technology = () => {
    return (
        <motion.div
            initial={{ opacity: 0 }}
            whileInView={{ opacity: 1 }}
            className="w-full min-h-[90dvh] grid grid-cols-1 lg:grid-cols-2 text-white">
            <div className="flex justify-center items-center">
                <motion.div
                    initial={{ opacity: 0 }}
                    whileInView={{ opacity: 1 }}
                    className="h-3/4 w-2/4">
                    <DirectionAwareHover imageUrl={'/images/tech-img.jpeg'}>
                        <div></div>
                    </DirectionAwareHover>
                </motion.div>
            </div>
            <div className="flex flex-col gap-6 py-14">
                <h2 className="text-5xl font-bold">TECHNOLOGY</h2>
                <h2 className="w-3/4">
                    Experience the power of cloud-based fast servers designed to meet the needs of everyone.
                </h2>
                <div className="w-3/4 grid grid-cols-1 gap-4">
                    {technology.map((val, i) => (

                        <FeatureCard
                            index={i}
                            key={i}
                            title={val.title}
                            description={val.description}
                            logo={val.logo}
                        />
                    ))}
                </div>
            </div>
        </motion.div>

    )
}

export default memo(Technology)