"use client";

import React, { ReactNode, useState } from "react";
import {
    motion,
    AnimatePresence,
    useScroll,
    useMotionValueEvent,
} from "framer-motion";
import { cn } from "@/lib/utils";

export const FloatingNav = ({ children }: { children: ReactNode }) => {
    const { scrollY } = useScroll();
    const [visible, setVisible] = useState(true);
    const [lastScrollY, setLastScrollY] = useState(0);

    useMotionValueEvent(scrollY, "change", (currentScrollY) => {
        if (typeof currentScrollY === "number") {
            if (currentScrollY < lastScrollY) {
                setVisible(true);
            } else {
                setVisible(false);
            }
            setLastScrollY(currentScrollY);
        }
    });

    return (
        <AnimatePresence mode="wait">
            <motion.div
                initial={{
                    opacity: 1,
                    y: 0,
                }}
                animate={{
                    y: visible ? 0 : -100,
                    opacity: visible ? 1 : 0,
                }}
                transition={{
                    duration: 0.2,
                }}
                className={cn(
                    "flex max-w-fit fixed top-5 inset-x-0 mx-auto rounded-full dark:bg-black/80 bg-white shadow-lg z-[5000] px-2 py-2 items-center justify-center space-x-4 gradientBorder"
                )}
            >
                {children}
            </motion.div>
        </AnimatePresence>
    );
};
