type CallsType = {
    id: number;
    section?: string
    imgSrc: string;
    title: string;
    description?: string[];
    featuresTitle?: string;
    featuresDescription?: string;
    features?: string[];
    bottomDescription?: string[];
}


export const CallsTypeData: CallsType[] = [
    {
        id: 0,
        imgSrc: '/images/8562_1492249347_InternetServices2-1-2.png',
        title: 'Call Types?',
        description: [
            'All-Calls Call Center Services provides American based agents for most contact types. \nWhether you need inbound, outbound or blended agents, we have the program to meet your needs.',
            'With our unique business model, All-Calls is the expert in finding unique talent, with virtually unlimited specialties, certifications and experiences. Without the geographical limitations of a brick and mortar facility and our vast recruiting resources across the US, we can find the talent needed to provide an exceptional customer experience.',
            'Need to provide omnichannel support that includes web chat, email response, social or text services, All-Calls can help.'
        ]
    }
]

export const TypesOfCalls: CallsType[] = [
    {
        id: 1,
        imgSrc: '/images/call-answering-service.jpg',
        title: 'CLI Route?',
        description: [
            "In CLI Route the recipient will receive the call after it goes through a chain of carriers. In this type of VoIP Route, the Caller ID is visible. This VoIP Route is commonly called the White Route."
        ]
    },
    {
        id: 2,
        imgSrc: '/images/Non-CLI Route.jpg',
        title: 'Non-CLI Route?',
        description: [
            "The Caller ID is not visible at the call destination in this type of Non-CLI or Grey Route. A GSM gateway can terminate this type of calls."
        ]
    },
    {
        id: 3,
        imgSrc: '/images/types-phone-numbers-feature.jpg',
        title: 'Direct Routes?',
        description: [
            "When the Route Provider has a piece of terminating equipment, it forms a direct route as there are no intermediaries. The call passes directly from the device to the provider before reaching its final destination."
        ]
    },
    {
        id: 4,
        imgSrc: '/images/Transitioning-from-TDM-Voice-to-SIP.jpg',
        title: 'TDM?',
        description: [
            "TDM stands for Time Division Multiplexing. In this the termination of the VoIP Route with time-division multiplexing takes place. This is similar to a traditional phone service set up over a phone line."
        ]
    },
    {
        id: 5,
        imgSrc: '/images/SIP_Trunk.jpg',
        title: 'PRI?',
        description: [
            "PRI stands for Primary Rate Interface. Integrated Services Digital Network uses PRI for carrying multiple DSO voice and data transmissions between network and user. This type of route is a bit uncommon."
        ]
    },
    {
        id: 6,
        imgSrc: '/images/stockfresh_8245621_female-customer-services-agent-in-call-center_sizeS.jpg',
        title: 'What is an Outbound Call?',
        description: [
            "An outbound call center is a function of a business operation that employs customer support agents and/or sales representatives to make outgoing calls to third parties—namely customers, prospects, or other businesses",
            "Outbound call centers may make outbound calls exclusively, or they may combine outbound and inbound calling. An outbound call, unlike an inbound call, can be defined as a call that originates with a sales or support representative dialing a third party’s telephone number, such as a prospect or customer. Depending on the type of business and the larger industry, companies use outbound call centers for the following purposes:"
        ],
        features: [
            "Telemarketing sales cold calls",
            "Customer service calls",
            "Marketing Research",
            "Nonprofit or charity fundraising",
            "Updating contact lists",
            "Surveys outreach",
            "Customer notifications",
            "Requesting information from other businesses",
            "Post-sale follow-ups",
        ],
        bottomDescription: [
            "But an outbound call center can only fulfill its purpose when it’s efficient and effective. By using metrics to measure an outbound call center’s performance, companies will improve the customer experience which has a positive impact on their retention rates and reputation.",
            "Some of the important areas that outbound call centers concentrate on are having clean and accurate call lists, having the customer’s history in front of them, and having high connect and conversion rates.",
        ]
    },
    {
        id: 7,
        imgSrc: '/images/browser-calling.jpg',
        title: 'Press 1 Calls?',
        description: [
            "Press 1 voice campaigns are calling campaigns where people press the number 1 on their phones to interact with the campaign. By pressing a digit, people can take advantage of the offer, transfer their call to a live agent, or leave a message for the business that sent out the campaign."
        ]
    },
]
