type DigitalMarketingType = {
    id: number;
    imgSrc: string;
    title: string;
    description: string[];
    featuresTitle?: string;
    featuresDescription?: string;
    features?: string[];
    bottomDescription?: string[];

}
export const DigitalMarketingData: DigitalMarketingType[] = [
    {
        id: 0,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "What is Digital Marketing?",
        description: ['Any marketing that uses electronic devices to convey promotional messaging and measure its impact. In practice, digital marketing typically refers to marketing campaigns that appear on a computer, phone, tablet, or other device. It can take many forms, including online video, display ads, and social media posts. Digital marketing is often compared to “traditional marketing” such as magazine ads, billboards, and direct mail. Oddly, television is usually lumped in with traditional marketing.'],
        featuresTitle: "Digital Marketing Assets",
        featuresDescription: "Almost anything can be a digital marketing asset. It simply needs to be a marketing tool you use online. That being said, many people don’t realize how many digital marketing assets they have at their disposal. Here are just a few examples:",
        features: [
            "Your website",
            "Branded assets (logos, icons, acronyms, etc)",
            "Video content (video ads, product demos, etc)",
            "Images (infographics, product shots, company photos, etc)",
            "Written content (blog posts, eBooks, product descriptions, testimonials, etc)",
            " Online products or tools (SaaS, calculators, interactive content, etc)",
            "Reviews",
            " Social media pages"
        ],
    }
]

export const TypesOfDigitalMarketing: DigitalMarketingType[] = [
    {
        id: 1,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Search engine optimization",
        description: [
            "Search engine optimization, or SEO, is technically a marketing tool rather than a form of marketing in itself. The Balance defines it as \"the art and science of making web pages attractive to search engines.\"",
            "The \"art and science\" part of SEO is what’s most important. SEO is a science because it requires you to research and weigh different contributing factors to achieve the highest possible ranking. Today, the most important elements to consider when optimizing a web page include:"
        ],
        features: [
            " Quality of content",
            "Level of user engagement",
            " Mobile-friendliness",
            "Number and quality of inbound links",
        ],
        bottomDescription: [
            "The strategic use of these factors makes SEO a science, but the unpredictability involved makes it an art.",
            "In SEO, there's no quantifiable rubric or consistent rule for ranking highly. Google changes its algorithm almost constantly, so it's impossible to make exact predictions. What you can do is closely monitor your page's performance and make adjustments accordingly.",
        ]
    },

    // item 2
    {
        id: 2,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Content marketing",
        description: [
            "SEO is a major factor in content marketing, a strategy based on the distribution of relevant and valuable content to a target audience.",
            "As in any marketing strategy, the goal of content marketing is to attract leads that ultimately convert into customers. But it does so differently than traditional advertising. Instead of enticing prospects with potential value from a product or service, it offers value for free in the form of written material",
        ],
        featuresTitle: "Content marketing matters, and there are plenty of stats to prove it:",
        featuresDescription: "",
        features: [
            " 84% of consumers expect companies to produce entertaining and helpful content experiences",
            " 62% of companies that have at least 5,000 employees produce content daily",
            " 92% of marketers believe that their company values content as an important asset",
        ],
        bottomDescription: [
            "As effective as content marketing is, it can be tricky. Content marketing writers need to be able to rank highly in search engine results while also engaging people who will read the material, share it, and interact further with the brand. When the content is relevant, it can establish strong relationships throughout the pipeline.",
        ]

    },

    // item 3
    {
        id: 3,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Social media marketing",
        description: [
            "bSocial media marketing means driving traffic and brand awareness by engaging people in discussion online. The most popular platforms for social media marketing are Facebook, Twitter, and Instagram, with LinkedIn and YouTube not far behind.",
            "Because social media marketing involves active audience participation, it has become a popular way of getting attention. It's the most popular content medium for B2C marketers at 96%, and it's gaining ground in the B2B sphere as well. According to the Content Marketing Institute, 61% of B2B content marketers increased their use of social media this year.",
            "Social media marketing offers built-in engagement metrics, which are extremely useful in helping you to understand how well you're reaching your audience. You get to decide which types of interactions mean the most to you, whether that means the number of shares, comments, or total clicks to your website.",
            "Direct purchase may not even be a goal of your social media marketing strategy. Many brands use social media marketing to start dialogues with audiences rather than encourage them to spend money right away. This is especially common in brands that target older audiences or offer products and services not appropriate for impulse buys. It all depends on your company's goals",
        ],
    },

    // item 4
    {
        id: 4,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Pay-per-click marketing",
        description: [
            "Pay-per-click, or PPC, is posting an ad on a platform and paying every time someone clicks on it.",
            "How and when people see your ad is a bit more complicated. When a spot is available on a search engine results page, also known as a SERP, the engine fills the spot with what is essentially an instant auction. An algorithm prioritizes each available ad based on a number of factors, including:",
        ],
        features: [
            "Ad quality",
            "Keyword relevance",
            "Landing page quality",
            "Bid amount",
        ],
        bottomDescription: [
            "Each PPC campaign has 1 or more target actions that viewers are meant to complete after clicking an ad. These actions are known as conversions, and they can be transactional or non-transactional. Making a purchase is a conversion, but so is a newsletter signup or a call made to your home office.",
            "Whatever you choose as your target conversions, you can track them via your chosen platform to see how your campaign is doing.",
        ]

    },

    // item 5
    {
        id: 5,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Affiliate marketing",
        description: [
            "Affiliate marketing lets someone make money by promoting another person's business. You could be either the promoter or the business who works with the promoter, but the process is the same in either case.",
            "It works using a revenue sharing model. If you're the affiliate, you get a commission every time someone purchases the item that you promote. If you're the merchant, you pay the affiliate for every sale they help you make.",
            "Some affiliate marketers choose to review the products of just 1 company, perhaps on a blog or other third-party site. Others have relationships with multiple merchants.",
            "Whether you want to be an affiliate or find one, the first step is to bmake a connection with the other party. You can use a platform designed to connect affiliates with retailers, or you can start or join a single-retailer program.",
            "If you're a retailer and you choose to work directly with affiliates, there are many things you can do to make your program appealing to potential promoters. You'll need to provide those affiliates with the tools that they need to succeed. That includes incentives for great results as well as marketing support and pre-made materials.",
        ],
    },

    // item 6
    {
        id: 6,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Native advertising",
        description: [
            "Native advertising is marketing in disguise. Its goal is to blend in with its surrounding content so that it\'s less blatantly obvious as advertising.",
            "Native advertising was created in reaction to the cynicism of today's consumers toward ads. Knowing that the creator of an ad pays to run it, many consumers will conclude that the ad is biased and consequently ignore it.",
            "A native ad gets around this bias by offering information or entertainment before it gets to anything promotional, downplaying the \"ad\" aspect.",
            "It\'s important to always label your native ads clearly. Use words like “promoted” or “sponsored.” If those indicators are concealed, readers might end up spending significant time engaging with the content before they realize that it's advertising.",
            "When your consumers know exactly what they're getting, they'll feel better about your content and your brand. Native ads are meant to be less obtrusive than traditional ads, but they’re not meant to be deceptive.",
        ],
    },

    // item 7
    {
        id: 7,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Marketing automation",
        description: [
            "Marketing automation uses software to power digital marketing campaigns, improving the efficiency and relevance of advertising.",
        ],
        featuresTitle: "According to statistics:",
        featuresDescription: "",
        features: [
            "90% of US consumers find personalization either “very” or “somewhat” appealing",
            " 81% of consumers would like the brands they engage with to understand them better",
            " 77% of companies believe in the value of real-time personalization, yet 60% struggle with it",
            " Send and post marketing messages at the right times to the right audiences",
        ],
        bottomDescription: [
            "Many marketing automation tools use prospect engagement (or lack thereof) with a particular message to determine when and how to reach out next. This level of real-time customization means that you can effectively create an individualized marketing strategy for each customer without any additional time investment.",
        ]
    },

    // item 8
    {
        id: 8,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Email marketing",
        description: [
            "The concept of email marketing is simple—you send a promotional message and hope that your prospect clicks on it. However, the execution is much more complex. First of all, you have to make sure that your emails are wanted. This means having an opt-in list that does the following:",
        ],
        features: [
            " Individualizes the content, both in the body and in the subject line",

            " States clearly what kind of emails the subscriber will get",
            " Offers a clear unsubscribe option",
            " Integrates both transactional and promotional emails"
        ],
        bottomDescription: [
            "You want your prospects to see your campaign as a valued service, not just as a promotional tool.",
            "Email marketing is a proven, effective technique all on its own: 89% of surveyed professionals named it as their most effective lead generator.",
        ]
    },

    // item 9
    {
        id: 9,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Paid Social Media Advertising",
        description: [
            "Most social media platforms like Facebook, Instagram, Twitter, LinkedIn, Pinterest and Snapchat will allow you to run ads on their site. Paid social media advertising is great for building awareness with audiences that might not be aware that your business, product or service exists.",
        ],
    },

    // item 10
    {
        id: 10,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Does Digital Marketing Work?",
        description: [
            "Digital marketing is a great option for any business. At Disruptive, we’ve used digital marketing to help all kinds of businesses grow—from mom-and-pop shops to internationally recognized universities and beyond. That’s the beauty of advertising online. If you know who you want to target, you can use digital marketing to target anyone, anywhere.",
            "However, that being said, certain types of businesses will benefit more from certain types of digital advertising. As a quick overview, let’s take a look at which strategies tend to work best for business-to-consumer (B2C) companies and business-to-business (B2B) companies:",
        ],
    },

    // item 11
    {
        id: 11,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "B2C Companies",
        description: [
            "Generally speaking, B2C companies have much lower price points than their B2B counterparts. After all, it can be a little hard to sell a $150,000 drill bit (believe me, they exist) to a harried mom. But a $10 pair of kids pants? That\'s a fairly straightforward sell.",
            "The good news is, because B2C companies aren\'t trying to sell incredibly expensive products or services, they don\'t need big sales teams or complicated marketing funnels. All they have to do is get their products or services in front of the right audience with the right messaging and the rest should take care of itself.",
            "As a result, the primary goal of most B2C companies is to get people into and through their marketing funnel. For example, if you can get that harried mom onto your kids clothing website and offer her an exciting deal, there's a good chance that she'll buy today. You don't need to build a ton of brand awareness or trust before you can close a sale.",
            "With that in mind, B2C companies often see great results from higher-funnel marketing channels like social media marketing or paid social advertising. These channels do a great job of getting your business in front of potential customers who might not otherwise know that you exist.",
            "Now, supplementing with other digital marketing strategies like paid search or SEO is always a good idea, but if you have to pick one channel to start with, paid social advertising or social media marketing are great options for B2C.",
        ],
    },

    // item 12
    {
        id: 12,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "B2B Companies",
        description: [
            "In contrast, paid search is a great option for B2B companies. Most B2B companies have very specific niche audiences that can be hard to target using social media. However, if you sell $150,000 drill bits and someone searches for “diamond-tipped oil drilling bit manufacturer”, you want to be the first result they see. Yes, you might pay more for your click than you would with paid social advertising, but with a $150,000 price tag, it's money well spent.",
            "In addition, most B2B companies have a much longer and more involved sales cycle than B2C companies. If you're selling a $150,000 drill bit, most people probably don't come to your site, give you a call and say “I want one.” As a result, longer-term strategies like content marketing or email marketing are often necessary to close a deal."
        ],
    },

    // item 13
    {
        id: 13,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "How Do I Get Started?",
        description: [
            "The good news is, getting started with digital marketing is fairly easy. Most online advertising platforms make it easy to sign up and create your first campaign (it is how they make money, after all). Here are a few links to beginner guides for several different digital marketing strategies:",
        ],
        featuresTitle: "General Information About Digital Marketing",
        featuresDescription: "",
        features: [
            "Paid search advertising",
            "Search engine optimization (SEO)",
            " Paid social media advertising",
            " Social media marketing",
            " Conversion rate optimization",
            " Content marketing",
            " Email marketing",
        ],
    },
]

// ----------       faqs        ----------
type FAQsType = {
    title: string;
    description: string[];
}

export const FAQsData: FAQsType[] = [
    {
        title: "How Much Do You Need to Make?",
        description: [
            "To figure out what you need to spend on digital marketing, you first need to clarify what your goals are. How you approach digital marketing can vary quite a bit depending on whether your ultimate goal is to drive clicks, conversions or leads, sales, revenue or a certain return-on-investment (ROI).",
            "When you get right down to it, the ultimate goal of any marketing effort should be ROI. After all, if your digital marketing spend isn't driving profitable revenue for your business, why are you marketing online?"
        ]
    },
    {
        title: "Who Are You Marketing To?",
        description: [
            "Once you know how much money you want to make from digital marketing, you need to identify who you are marketing to. This is critical, because different buyer personas require different marketing tactics. And, even more importantly, different buyer personas turn into different types of buyers.",
            "So guess what? If you don't understand your buyer personas, you can't create an effective digital marketing strategy!",
            "If you've got a sales team, talking to sales can be one of the fastest ways to get a decent buyer persona together. After all, they're the ones who talk to your customers the most, right?",
        ]
    },
    {
        title: "What are Your Customer Worth?",
        description: [
            "Typically, people look at buyer personas as a good way to craft an effective marketing strategy. Buyer personas are great for this, but they are also an important part of putting together an effective digital marketing plan.",
        ]
    },
    {
        title: "How Much Do You Need to Spend to Reach Your Goals?",
        description: [
            "At this point, things are pretty simple. Just take your CAC, average purchase order value and average number of purchases (if you have a subscription model, you can just use the average lifespan of each buyer persona here) and plug them into this calculator!",
        ]
    },
]