type SEO_Type = {
    id: number;
    imgSrc: string;
    title: string;
    description: string[];
    featuresTitle?: string;
    featuresDescription?: string;
    features?: string[];
    bottomDescription?: string[];
}

type SEO_Tips = {
    title: string;
    description: string[];
    listItem?: string[];
}

// seo data
export const SEO_Data: SEO_Type[] = [
    {
        id: 0,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Search Engine Optimization?",
        description: [
            "Any marketing that uses electronic devices to convey promotional messaging aSEO means Search Engine Optimization and is the process used to optimize a website's technical configuration, content relevance and link popularity so its pages can become easily findable, more relevant and popular towards user search queries, and as a consequence, search engines rank them better.",
            "Search engines recommend SEO efforts that benefit both the user search experience and page’s ranking, by featuring content that fulfills user search needs. This includes the use of relevant keywords in titles, meta descriptions, and headlines (H1), featuring descriptive URLs with keywords rather than strings of numbers, and schema markup to specify the page's content meaning, among other SEO best practices."
        ],
    },
    {
        id: 1,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "What is SEO?",
        description: [
            "SEO stands for search engine optimization, which helps your page rank higher on Google and other search engines for relevant, targeted queries - and therefore, to attract more user clicks, as they tend to click on the first result - todrive more traffic to your site.",
            "You can optimize your pages based on what search engines look for in a website, which changes as technology trends continue to evolve. And if you haven’t done so already, you can adjust your web presence to make sure it's useful and informative.",
            "But SEO hasn't always been this way. In the early days of the internet, search engines ranked sites by how many times each site used a particular keyword. This led to a practice known as \"keyword stuffing,\" and it meant that even high-quality sites could easily get buried. Now Google prioritizes quality over keyword density.",
            "If you have a website, that’s good news, because you can invest time and talent to create a site that makes you more likely to rank highly.",
            "To learn how, you need to understand how search engines work. We'll use Google as an example because it powers the most searches in the world.",
        ],
    },
    {
        id: 2,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "How does SEO work?",
        description: [
            "Search engines such as Google and Bing use bots to crawl pages on the web, going from site to site, collecting information about those pages and putting them in an index. Next, algorithms analyze pages in the index, taking into account hundreds of ranking factors or signals, to determine the order pages should appear in the search results for a given query.",
            "Search ranking factors can be considered proxies for aspects of the user experience. Our Periodic Table of SEO Factors organizes the factors into six main categories and weights each based on its overall importance to SEO. For example, content quality and keyword research are key factors of content optimization, and crawlability and mobile-friendliness are important site architecture factors.",
            "The search algorithms are designed to surface relevant, authoritative pages and provide users with an efficient search experience. Optimizing your site and content with these factors in mind can help your pages rank higher in the search results.",
        ],
    },
    {
        id: 3,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Why is SEO important for marketing?",
        description: [
            "SEO is a fundamental part of digital marketing because people conduct trillions of searches every year, often with commercial intent to find information about products and services. Search is often the primary source of digital traffic for brands and complements other marketing channels. Greater visibility and ranking higher in search results than your competition can have a material impact on your bottom line.",
            "However, the search results have been evolving over the past few years to give users more direct answers and information that is more likely to keep users on the results page instead of driving them to other websites.",
            "Also note, features like rich results and Knowledge Panels in the search results can increase visibility and provide users more information about your company directly in the results.",
        ],
    },
    {
        id: 4,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "How does Google work?",
        description: [
            "When you enter a search term, Google's algorithm determines which of the countless websites out there will be most relevant to you. It then lists the relevant sites taking into consideration their relevance and popularity -among other ranking factors - and shows them to you on what the industry calls a search engine results page.",
        ],
    },
    {
        id: 5,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Crawling",
        description: [
            "Google is constantly searching the web looking for new or updated pages, simulating the bheavior os users. It uses programs known as web crawlers, which follow links across the internet, a process also known as crawling, and report what they find to Google's servers.",
            "That’s why it’s fundamental to make sure that your pages are accessible to be crawled and your site architecture should facilitate navigation across all site pages, by the effective usage of internal linking.",
            "Technical SEO is the aspect of SEO that will help to effectively configure your site to optimize its crawlability. There’s a variety of SEO tools that can help you with this task.",
        ],
    },
    {
        id: 6,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Indexing",
        description: [
            "When Google's web crawlers return information about a website, a collection of internal servers analyzes each page's content to determine its topics.",
            "If Google considers that the page information can be useful and relevant to be shown in search results, it will keep it in its index ready to be served whenever someone searches for a relevant topic.",
        ],
        featuresTitle: "That's why its important to:",
        features: [
            " Make sure that each page is only shown through a single URL (avoiding duplicated content)",
            " Use concise and relevant page titles and headings for each page",
            "Feature unique, comprehensive descriptive text information in each page",
            "Add alt text, or text that shows in place of images, to help Google process video and image content",
        ],
        bottomDescription: [
            "The clearer you are about the page's content, the more accurate the indexing process will be. That's why content marketing is key for SEO success."
        ]
    },
    {
        id: 7,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "Ranking",
        description: [
            "When someone conducts a search, Google determines which pages appear first to provide the best user experience by considering factors such as:",
        ],
        features: [
            "The words used in the search query",
            "The user's location",
            "The page's information relevance, trustworthiness, expertise and authority towards the searched terms",
            "The page's link popularity",
            "The pages configuration to provide a fast, reliable experience: such as its speed and mobile friendliness."
        ],
        bottomDescription: [
            "The ongoing challenge of SEO is making sure that pages on your site perform better than all others about the same topic, taking into account the above mentioned SEO factors, so a page can continue to perform better in search results, independently of algorithm changes.."
        ]
    },
    {
        id: 8,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "What helps you rank higher today?",
        description: [
            "Since the 1990s, search engines have used algorithms to determine what sites should show up first on their results pages. What those algorithms prioritize, however, has changed—a lot.",
            "Since the days of keyword stuffing, Google has been working hard to understand what makes a website relevant and informative. It applies this knowledge every few months when it releases a new update designed to rank sites more effectively.",
            "Google still considers the usage and inclusion of the targeted keyword within the content when ranking websites, although the quality of the information matters too.",
        ],
        featuresTitle: "Google judges quality based on:",
        features: [
            "Relevance to the search",
            "Expertise, authoritativeness, and trustworthiness of the source",
            "Usability of the site",
            "Mobile friendliness and adaptability between browsers",
            "Page load speeds"
        ],
        bottomDescription: [
            "Some of these factors are on-page, meaning that they're part of how you experience the website. Others are off-page, like other sites linking to yours. Links are seen as “votes” or endorsements by Google. Off-page elements strengthen your site’s reputation and popularity to improve its ranking.",
            "Classifying the different areas to be optimized by whether they're on-page or off-page will help you develop an effective SEO strategy. On-page SEO and off-page SEO both help you rank more highly, but the ways to put them into practice are quite different."
        ]
    },
    {
        id: 9,
        imgSrc: "/images/digital_marketing-main.jpg",
        title: "On-Page Optimization for SEO?",
        description: [
            "The best way to differentiate on-page and off-page SEO is by the terms themselves.",
            "On-page SEO refers to the elements that are included on the site, technical configurations as well as content, that search engines will take into consideration, including but not limited to:",
        ],
        features: [
            "Title Tags",
            "Meta Descriptions",
            "Usability of the site",
            "Headings",
            "URL structure",
            "Main page copy",
            "Image Alt descriptions",
            "Load speed",
            "Mobile friendliness",
        ],
    },
]

// seo faqs data
export const SEO_FAQs: SEO_Tips[] = [
    {
        title: "Title Tags",
        description: [
            "While Google is working to better understand the actual meaning of a page and de-emphasizing (and even punishing) aggressive and manipulative use of keywords, including the term (and related terms) that you want to rank for in your pages is still valuable. And the single most impactful place you can put your keyword is your page’s title tag.",
            "The title tag is not your page’s primary headline. The headline you see on the page is typically an H1 (or possibly an H2) HTML element. The title tag is what you can see at the very top of your browser, and is populated by your page’s source code in a meta tag:",
        ],
    },
    {
        title: "Meta Descriptions",
        description: [
            "While the title tag is effectively your search listing’s headline, the meta description (another meta HTML element that can be updated in your site’s code, but isn’t seen on your actual page) is effectively your site’s additional ad copy. Google takes some liberties with what they display in search results, so your meta description may not always show, but if you have a compelling description of your page that would make folks searching likely to click, you can greatly increase traffic. (Remember: showing up in search results is just the first step! You still need to get searchers to come to your site, and then actually take the action you want.)",
        ],
    },
    {
        title: "Body Content",
        description: [
            "The actual content of your page itself is, of course, very important. Different types of pages will have different “jobs” – your cornerstone content asset that you want lots of folks to link to needs to be very different than your support content that you want to make sure your users find and get an answer from quickly. That said, Google has been increasingly favoring certain types of content, and as you build out any of the pages on your site, there are a few things to keep in mind:",
        ],
        listItem: [
            "Thick & Unique Content",
            "Engagement",
            "Sharability",
        ]
    },
    {
        title: "Alt Attributes",
        description: [
            "How you mark up your images can impact not only the way that search engines perceive your page, but also how much search traffic from image search your site generates. An alt attribute is an HTML element that allows you to provide alternative information for an image if a user can’t view it. Your images may break over time (files get deleted, users have difficulty connecting to your site, etc.) so having a useful description of the image can be helpful from an overall usability perspective. This also gives you another opportunity – outside of your content – to help search engines understand what your page is about",
            "You don’t want to “keyword stuff” and cram your core keyword and every possible variation of it into your alt attribute. In fact, if it doesn’t fit naturally into the description, don’t include your target keyword here at all. Just be sure not to skip the alt attribute, and try to give a thorough, accurate description of the image (imagine you’re describing it to someone who can’t see it – that’s what it’s there for!).",
        ],
    },
    {
        title: "URL Structure",
        description: [
            "Your site’s URL structure can be important both from a tracking perspective (you can more easily segment data in reports using a segmented, logical URL structure), and a shareability standpoint (shorter, descriptive URLs are easier to copy and paste and tend to get mistakenly cut off less frequently). Again: don’t work to cram in as many keywords as possible; create a short, descriptive URL.",
            "Moreover: if you don’t have to, don’t change your URLs. Even if your URLs aren’t “pretty,” if you don’t feel as though they’re negatively impacting users and your business in general, don’t change them to be more keyword focused for “better SEO.” If you do have to change your URL structure, make sure to use the proper (301 permanent) type of redirect. This is a common mistake businesses make when they redesign their websites.",
        ],
    },
    {
        title: "Schema & Markup",
        description: [
            "Finally, once you have all of the standard on-page elements taken care of, you can consider going a step further and better helping Google (and other search engines, which also recognize schema) to understand your page.",
            "Schema markup does not make your page show up higher in search results (it’s not a ranking factor, currently). It does give your listing some additional “real estate” in the search results, the way ad extensions do for your AdWords ads",
        ],
    },
]