import React from "react";
import { BsCloudArrowUpFill } from "react-icons/bs";
import { FaRegFlag, FaServer } from "react-icons/fa";
import { HiMiniServerStack } from "react-icons/hi2";

type SippyType = {
    id: number;
    imgSrc: string;
    title: string;
    description: string[];
    featuresTitle?: string;
    featuresDescription?: string;
    features?: string[];
    bottomDescription?: string[];
}

const Sippy: SippyType[] = [
    {
        id: 1,
        imgSrc: '/images/sippy-product.png',
        title: 'Sippy Softswitch Overview',
        description: [
            "A CLASS 4 (Wholesale) and Class 5 (Retail) cloud-based Softswitch solution powering hundreds of mid-tier interconnects, brokers and carriers, delivering you a conservative, yet comprehensive management solution to provide you with the opportunity to work on growing your business, rather than managing your operations. Sippy Hosted Solutions are ideal for VoIP entrepreneurs, startups, interconnects, and carriers.",
        ],
        features: [
            "Sippy Software has some of the most dynamic and flexible routing options available and automatically move calls to predefined alternative routes",
            "The Sippy billing engine provides a flexible and dynamic suite of tools to initiate new services and provide comprehensive pricing solutions",
            "The Voice telecom business is moving faster. It has now become important to be able to make real-time business decisions based on hard, accurate information",
            "Sippy XML-RPC APIs not only offers an advanced method for system administration. They also provide clients with an extremely powerful platform",
        ],
    },
    {
        id: 2,
        imgSrc: '/images/img-sippy.jpg',
        title: 'Sippy Softswitch Key features',
        description: [
            "This is the one on Softswitch for the retails and wholesale which is the combination with many features. the latest version of the Sippy Softswitch license installed on your own, self-­managed infrastructure. Based on Sippy B2BUA, Sippy Software has some of the most dynamic and flexible routing options available. Routing options can be imposed individually, or nested to provide even more routing options.",
        ],
        features: [
            "Unlimited Supplier (Vendor) Connections",
            "Adaptive Routing based on ASR/ACD (Flexible Crankback management)",
            "ASR / ACD Quality monitoring",
            "Profit / Loss Protection (Margin based Routing)",
            "LRN / Number Portability Lookup",
            "DNCL Supported – Black List, Block List, Do-not call list",
            "Support GSM, G.711a, G.711u, G.722, G.723, G.728, G.729 Pass-through",
            "Network packet capture abilities – ability to capture network traffic for off-line analysis in wireshark or other industry standard tools",
            "Use Sippy as the foundation to your completely flexible VOIP business. Develop Custom solutions and integrations on top of Sippy.",
            "Language agnostic – Developers can integrate using their language of choice, python, java, PHP, ruby etc",
        ],
    },
    {
        id: 3,
        imgSrc: '/images/school-admin-software.jpg',
        title: 'Sippy Softswitch Administration',
        description: [
            "Sippy provides your NOC with the tools to install, support, and maintain the physical servers where our Sippy Softswitch Licenses reside. These tools include Web-portal and email access to the Sippy technical support team who can provide round-the-clock support, assistance, and guidance on the optimum use of your Sippy Softswitch. Virtually every aspect of your Sippy Softswitch is designed to provide you with complete administration and configuration of the features and as such there are too many options to list in one place. Some of the core administration features that users request, include:",
        ],
        features: [
            "Network Activity Recorder for analysis and debugging purposes",
            "Re-rate CDR tool",
            "Web-based Ping/Traceroute analysis tool",
            "Destination/Prefix management",
            "IP Firewall Management for SIP, Web, SSH, and Database access",
            "Access Controls for Web users",
            "Complete control Web Interface – All switch management features are available from your user interface",
        ],
    },
    {
        id: 4,
        imgSrc: '/images/invoicefactoring.jpg',
        title: 'Sippy Softswitch Billing System',
        description: [
            "The Sippy Billing engine is heavily relied upon not just for voice-related services, but as a unified billing solution for multiple business services (such as SMS and Triple Play solutions like IPTV, video-on-demand, and data usage.",
            "he Sippy billing engine provides a flexible and dynamic suite of tools to initiate new services, provide comprehensive pricing solutions for both pre-paid, post-paid clients, wholesale, carrier, and call center solutions providers. In addition, the Sippy customer Invoice Template tool allows clients to build unique, custom invoice templates to match the business branding. Options include:",
        ],
        features: [
            "'Real-time' billing",
            "Flexible Weekly, Fortnightly, and Monthly Billing Cycles",
            "Configurable billing pattern for call rating (Example: 30:6, 1:1 for per-second billing)",
            "Pre and Postpaid Service Plans",
            "DID/CLD accessibility surcharge support",
            "Configurable Service Plan fixed fees (Example: Monthly Plan fee)",
            "Billing failure action management",
            "Destination based Minute Plan support",
            "Configurable rounding method (round up, round) for Customer and Vendor CDRs",
            "Improved Invoicing Generation",
            "Payment processor integration for automatic client payments on low balance via Credit Card or Paypal",
            "Low Balance notifications and Automatic Payment features",
            "Currency support",
            "162 default currencies",
            "Manual or automatic exchange rate",
            "Time zones can be configured on individual Vendor or Client basis",
            "External Balance Daemon for Centralized Balance Management",
        ],
    },
    {
        id: 5,
        imgSrc: '/images/Branding3.png',
        title: 'Sippy Softswitch User Portal',
        description: [
            "For clients that purchase or rent (Sippy FLEX) their own Sippy Softswitch License, there is the option to create additional virtual Sippy Softswitch Environments (or Partitions). The main purpose of virtual Sippy Environments is to create an isolated / Self-managed (either your own use or to rent to other route providers) Softswitch that is independent of the main Softswitch and any other Environments. The Virtual Environment has its own administration, authentication, routing, rating, and billing regardless of whatever else is configured on other Environments.",
            "Virtual Environments are often used to separate production traffic from trial routes and traffic, to seperate retail traffic from wholesale routes, or to create mini-self contained Softswitch instances to provide to customers needing a Softswitch solution.",
        ],
        features: [
            "White-label Reseller portal",
            "Capacity Partitioning",
            "IP and Port management",
            "Expiration date supported",
            "Flexible Performance and Capacity management",
            "Web Interface accessibility management",
            "Available for Dedicated, FLEX and Perpetual purchase licenses",
        ],
    }
]

const Price = [
    {
        id: 1,
        icon: React.createElement(HiMiniServerStack),
        core: "2 Core Dedicated Server",
        cpu: "Intel® Xeon E3-1270 v3 2.40 GHz",
        price: "49",
        features: [
            "4 GB RAM",
            "250 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 5000 GB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 2,
        icon: React.createElement(HiMiniServerStack),
        core: "4 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2620 v3 2.50 GHz",
        price: "99 ",
        features: [
            "8 GB RAM",
            "350 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 10 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 3,
        icon: React.createElement(HiMiniServerStack),
        core: "8 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2630 v3 2.60 GHz",
        price: "129",
        features: [
            "16 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 20 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 4,
        icon: React.createElement(HiMiniServerStack),
        core: "8 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2630 v3 2.60 GHz",
        price: "149 ",
        features: [
            "16 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 1 Gbps",
            "Bandwidth 50 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 5,
        icon: React.createElement(HiMiniServerStack),
        core: "12 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2620 v3 2.50 GHz",
        price: "179",
        features: [
            "32 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 1Gbps",
            "Bandwidth 50 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 16,
        icon: React.createElement(HiMiniServerStack),
        core: "16 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2630 v3",
        price: "380",
        features: [
            "64 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 20 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
]

const SippyFaqs = [
    {
        title: 'Can I rent or onetime install Sippy softswitch?',
        description: [
            'Yes, we offer both to rent and to onetime installation to your server. We have a mobile dialer VoIP which you can add with your Sippy Soft and you can do both wholesale and retails VoIP business.'
        ],
    },
    {
        title: 'DO you offer trainings?',
        description: [
            'Yes, we give training and others tutorial documentation with videos. Usually we provide an online session but also when requested we provide onsite training, it can be in our offices or at customer.'
        ],
    },
    {
        title: 'Can I host the softswitch on your server?',
        description: [
            'Yes, we work with the datacenter in USA and Europe an can offer you a full of package including server, backup, IP addresses etc. If you are asian, we have high redundant singapore server also we care about terminated and call genaration server location which you get better call quality to fine tune. We can suggest you which colocation is better for your termination.'
        ],
    },
    {
        title: 'What are the difference between Sippy and other Softswitch?',
        description: [
            'CLASS 4 (Wholesale) and Class 5 (Retail) Softswitch solutions designed to be as flexible as your business. With built-in web portals for Administration, Customers, Resellers, and accounts – OR – build your own portals and integrate with your existing systems using the Sippy APIs. You can do all types of VoIP business with that switch but another switch not have all this option combine.'
        ],
    },
    {
        title: 'Can I branded my company logo detail, is there any extra cost?',
        description: [
            'Yes, it can be branded, not only logo can be changed but the whole skin which is based on web backend preferences. You can do it yourself or order it at our design team.'
        ],
    },
    {
        title: 'Do I need a extra billing system?',
        description: [
            'The billing system is built in the Sippyswitch platform and is fully integrated with Softswitch providing realtime and rating functionality among many other converged billing features. It uses an external database to store the data.'
        ],
    },

]

const SippyWorth = [
    {
        id: 1,
        icon: React.createElement(FaServer),
        number: "4523+",
        content: 'Installation provided third party server'
    },
    {
        id: 2,
        icon: React.createElement(BsCloudArrowUpFill),
        number: "650+",
        content: 'Hosted solution provided'
    },
    {
        id: 3,
        icon: React.createElement(FaRegFlag),
        number: "35+",
        content: 'Countries we served'
    },
]
export { Sippy, Price, SippyFaqs, SippyWorth }