type SoftwareDevelopmentType = {
    id: number;
    imgSrc: string;
    title: string;
    description: string[];
    featuresTitle?: string;
    featuresDescription?: string;
    features?: string[];
    bottomDescription?: string[];
}

type SmallPricingType = {
    title: string;
    price: number;
    description?: string[];
    featuresList: {
        feature: string;
        available: boolean;
    }[];
};

export const SoftwareDevelopmentData: SoftwareDevelopmentType[] = [
    {
        id: 0,
        imgSrc: '/images/Software-development.jpg',
        title: 'Software Development',
        description: [
            'Software development is the process programmers use to build computer programs. The process, also known as the Software Development Life Cycle (SDLC), includes several phases that provide a method for building products that meet technical specifications and user requirements.',
            'The SDLC provides an international standard that software companies can use to build and improve their computer programs. It offers a defined structure for development teams to follow in the design, creation and maintenance of high-quality software. The aim of the IT software development process is to build effective products within a defined budget and timeline.',
        ]
    }
]

export const KeyStepsSoftwareDev: SoftwareDevelopmentType[] = [
    {
        id: 1,
        imgSrc: '/images/employee-recognition-ideas.png',
        title: 'Needs identification',
        description: [
            "Needs identification is a market research and brainstorming stage of the process. Before a firm builds software, it needs to perform extensive market research to determine the product's viability. Developers must identify the functions and services the software should provide so that its target consumers get the most out of it and find it necessary and useful. There are several ways to get this information, including feedback from potential and existing customers and surveys.",
            "The IT teams and other divisions in the company must also discuss the strengths, weaknesses and opportunities of the product. Software development processes start only if the product satisfies every parameter necessarily for its success."
        ]
    },
    {
        id: 2,
        imgSrc: '/images/write-a-professional-software-requirements-specification.png',
        title: 'Requirement analysis',
        description: [
            "Requirement analysis is the second phase in the software development life cycle. Here, stakeholders agree on the technical and user requirements and specifications of the proposed product to achieve its goals. This phase provides a detailed outline of every component, the scope, the tasks of developers and testing parameters to deliver a quality product.",
            "The requirement analysis stage involves developers, users, testers, project managers and quality assurance. This is also the stage where programmers choose the software development approach such as the waterfall or V model. The team records the outcome of this stage in a Software Requirement Specification document which teams can always consult during the project implementation."
        ]
    },
    {
        id: 3,
        imgSrc: '/images/Software_Development1.png',
        title: 'Design',
        description: [
            "Design is the third stage of the software development process. Here, architects and developers draw up advanced technical specifications they need to create the software to requirements. Stakeholders will discuss factors such as risk levels, team composition, applicable technologies, time, budget, project limitations, method and architectural design.",
            "The Design Specification Document (DSD) specifies the architectural design, components, communication, front-end representation and user flows of the product. This step provides a template for developers and testers and reduces the chances of flaws and delays in the finished product."
        ]
    },
    {
        id: 4,
        imgSrc: '/images/implementation3.ebf3da5a.jpg',
        title: 'Development and implementation',
        description: [
            "The next stage is the development and implementation of the design parameters. Developers code based on the product specifications and requirements agreed upon in the previous stages. Following company procedures and guidelines, front-end developers build interfaces and back-ends while database administrators create relevant data in the database. The programmers also test and review each other's code.",
            "Once the coding is complete, developers deploy the product to an environment in the implementation stage. This allows them to test a pilot version of the program to make performance match the requirements"
        ]
    },
    {
        id: 5,
        imgSrc: '/images/287-2877074_thumb-image-website-software-testing-hd-png-download.png',
        title: 'Testing',
        description: [
            "The testing phase checks the software for bugs and verifies its performance before delivery to users. In this stage, expert testers verify the product's functions to make sure it performs according to the requirements analysis document.",
            "Testers use exploratory testing if they have experience with that software or a test script to validate the performance of individual components of the software. They notify developers of defects in the code. If developers confirm the flaws are valid, they improve the program, and the testers repeat the process until the software is free of bugs and behaves according to requirements."
        ]
    },
    {
        id: 6,
        imgSrc: '/images/Deployment and maintenance.jpg',
        title: 'Deployment and maintenance',
        description: [
            "Once the software is defect-free, the developers can deliver it to customers. After the release of a software's production version, the IT software development company creates a maintenance team to manage issues clients encounter while using the product. Maintenance can be a hot-fix if it is a minor issue but severe software failures require an update."
        ]
    },
]

export const CostSoftwareDevelopment: SoftwareDevelopmentType[] = [
    {
        id: 1,
        imgSrc: '/images/software-development-costs.png',
        title: 'Cost',
        description: [
            "Software development costs can greatly vary. Upfront investments may be required in licenses for the selected programming language and tools, and training costs for software developers can be high. However, there are plenty of low costs or free tools and programming languages available, and if you pick a widely used development model and pay competitive salaries, you should be able to attract good software developers who can produce great products at an economical cost."
        ]
    }
]

export const Pricing: SmallPricingType[] = [
    {
        title: 'Basic',
        price: 199,
        featuresList: [
            {
                feature: "6 Months validity",
                available: true
            },
            {
                feature: "$ 80 Rental",
                available: true
            },
            {
                feature: "$ 120 Credits",
                available: true
            },
            {
                feature: "0 Exophone",
                available: true
            },
            {
                feature: "3 Agents",
                available: true
            },
            {
                feature: "Unlimited Channels",
                available: true
            },
            {
                feature: "Multilevel IVR",
                available: true
            },
        ]
    },
    {
        title: 'Standerd',
        price: 499,
        featuresList: [
            {
                feature: "12 Months validity",
                available: true
            },
            {
                feature: "$ 150 Rental",
                available: true
            },
            {
                feature: "$ 350 Credits",
                available: true
            },
            {
                feature: "0 Exophones",
                available: true
            },
            {
                feature: "6 Agents",
                available: true
            },
            {
                feature: "Unlimited Channels",
                available: true
            },
            {
                feature: "Multilevel IVR",
                available: true
            },
        ]
    },
    {
        title: 'Premium',
        price: 999,
        featuresList: [
            {
                feature: "12 Months validity",
                available: true
            },
            {
                feature: "$ 150 Rental",
                available: true
            },
            {
                feature: "$ 850 Credits",
                available: true
            },
            {
                feature: "1 Exophones",
                available: true
            },
            {
                feature: "Unlimited agents",
                available: true
            },
            {
                feature: "Unlimited Channels",
                available: true
            },
            {
                feature: "Multilevel IVR",
                available: true
            },
        ]
    },
]