import Icon from "@ant-design/icons";
import React from "react";
import { FaRegFlag, FaServer } from "react-icons/fa";
import { HiMiniServerStack } from "react-icons/hi2";
import { BsCloudArrowUpFill } from "react-icons/bs";

type VOS_Type = {
    id: number;
    imgSrc: string;
    title: string;
    description: string[];
    features?: string[];
}

type VosPricingType = {
    id: number,
    icon: React.ReactNode,
    core: string,
    cpu: string,
    price: string,
    features: string[],
    buttonTitle: string,
    buttonLink: string,
}

// types
export const VosOverview: VOS_Type[] = [
    {
        id: 0,
        imgSrc: '/images/vos1490048933.png',
        title: 'VOS3000 Overview',
        description: [
            "VOS3000 is made for a large amount of call handling carrier-grade Softswitch developed by Linknat Limited. It is a carrier-class Softswitch where you get Account Management, Rate Management, Package Management, Cards Management, Gateway Management, Phone Management, Softswitch Management, IVR Management, System Management, User Management, Data Query and Web Self-Service System."
        ],
        features: [
            "Large scale carrier-class capacity",
            "High stability",
            "User-defined routing strategy",
            "Support 10 million virtual number orders",
            "Support real-time billing, prepaid and postpaid",
            "Bill report: Revenue detail report, Gateway bill report, Account balance report, etc",
            "Login uses SHA512, RSA2048 encryption, storage uses AES128 encryption",
            "Routing according to LCR, area priority, gateway group",
        ]
    },
    {
        id: 1,
        imgSrc: '/images/vos3000-installation-1.jpg',
        title: 'VOS3000 Key features',
        description: [
            "The system also integrates add-on modules like the Calling Card/Call Back Business System (support 6 million cards) and Extreme Media Proxy, for you to build a stable, reliable, and high-performance operating system.",
            "VOS3000 Softswitch supports SIP/H323/SIP-H323, with capacity up to 5,000 simultaneous calls. After rigorous testing, the VOS3000 Softswitch proves to be a stable and reliable high-performance system."
        ],
        features: [
            "5,000 simultaneous calls with media proxy",
            "Gateway route backup, if some gateways are broken, business will not be influenced",
            "Support bill precision 0.0000001 and 3 millon fee rates",
            "Billing for every level agent at the same time",
            "Support billing for every level agent at the same time",
            "Support codec H.261, H.263, H.264, VP8 etc video coding,fax: T38, DTMF: RFC2833, SIP",
        ]
    },
    {
        id: 2,
        imgSrc: '/images/vosSecurity.jpg',
        title: 'VOS3000 Security',
        description: [
            "VOS3000 provide default firewall security which is Level 6 security handful for your server although we provide extra firewall CGI encryption IP allow and filed call blocking services which you get with all thing in one package. You can set different types of authority for many agents or multilevel resellers there you can set a firewall.",
        ],
        features: [
            "IP allow or deny based PHP script firewall system integration",
            "Login uses SHA512, RSA2048 encryption, storage uses AES128 encryption",
            "Support system log, which records the date, operator, IP, operations and etc",
            "IP, MAC login limit and send inform E-mail automatically",
            "Support setting different authority for different users",
        ]
    },
    {
        id: 3,
        imgSrc: '/images/invoicefactoring.jpg',
        title: "VOS3000 Billing System",
        description: [
            "VOS3000 users advanced asynchronous message bus and big data processing kernel, better than ordinary distributed systems. The client can seamlessly improve system performance and capacity by adding more services. The billing system is integrated with switch which can support 0.000001-second billing.",
        ],
        features: [
            "Handle real-time billing, prepaid and postpaid",
            "Support 10 millon class fee rates",
            "Matching according to caller/callee prefix",
            "Support period rate",
            "Support user-defined package",
        ]
    },
    {
        id: 4,
        imgSrc: '/images/vos3000-u.png',
        title: "VOS3000 Accounts & Report",
        description: [
            "VOS3000 can show full of the report in which you get class5 switch actually. There you get lots of ways to generate report with callee caller details header and many more.",
        ],
        features: [
            "Bill report: Revenue detail report, Gateway bill report, Account balance report etc",
            "Clearing report: Clearing account detail report, Clearing gateway detail report, Acount clearing balance report",
            "Analysis report: Mapping gateway analysis report, Routing gateway analysis report, Gateway area cross analysis report",
            "Web Interface billing report",
        ]
    },
]


// pricing
export const VosPrice: VosPricingType[] = [
    {
        id: 1,
        icon: React.createElement(HiMiniServerStack),
        core: "2 Core Dedicated Server",
        cpu: "Intel® Xeon E3-1270 v3 2.40 GHz",
        price: "49",
        features: [
            "4 GB RAM",
            "250 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 5000 GB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 2,
        icon: React.createElement(HiMiniServerStack),
        core: "4 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2620 v3 2.50 GHz",
        price: "99 ",
        features: [
            "8 GB RAM",
            "350 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 10 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 3,
        icon: React.createElement(HiMiniServerStack),
        core: "8 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2630 v3 2.60 GHz",
        price: "129",
        features: [
            "16 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 20 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 4,
        icon: React.createElement(HiMiniServerStack),
        core: "8 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2630 v3 2.60 GHz",
        price: "149 ",
        features: [
            "16 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 1 Gbps",
            "Bandwidth 50 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 5,
        icon: React.createElement(HiMiniServerStack),
        core: "12 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2620 v3 2.50 GHz",
        price: "179",
        features: [
            "32 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 1Gbps",
            "Bandwidth 50 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
    {
        id: 16,
        icon: React.createElement(HiMiniServerStack),
        core: "16 Core Dedicated Server",
        cpu: "Intel® Xeon E5-2630 v3",
        price: "380",
        features: [
            "64 GB RAM",
            "500 GB SCSI Hard Drives",
            "Internet Port 100 Mbps",
            "Bandwidth 20 TB",
            "24x7 Monitoring System",
            "Network Uptime SLA - 99.999%",
        ],
        buttonTitle: "Buy Now",
        buttonLink: "/contact",
    },
]


//faqs
export const VosFAQs = [
    {
        title: 'Can I rent or onetime install VOS3000 softswitch?',
        description: ['Yes, we offer both to rent and to onetime installation to your server. We have an extra firewall system which you give free with every switch.'],
    },
    {
        title: 'Can I host the softswitch on your server?',
        description: ['Yes, we work with the datacenter in USA and Europe an can offer you a full of package including server, backup, IP addresses etc. If you are asian, we have high redundant singapore server also we care about terminated and call genaration server location which you get better call quality to fine tune. We can suggest you which colocation is better for your termination.'],
    },
    {
        title: 'Can I do callcenter business with vos3000 switch?',
        description: ['This solution lets customers and enterprises fast interconnect, provide stable support for call center business.'],
    },
    {
        title: 'Can I Branded my company logo details, is there any extra cost?',
        description: ['Yes, it can be branded, not only logo can be changed but the whole skin which is based on web backend preferences. You can do it yourself or order it at our design team.'],
    },
    {
        title: 'Do i need a extra billing system?',
        description: ['The billing system is built in the VOS3000 platform and is fully integrated with the softswitch providing realtime and rating functionality among many other converged billing features. It uses an external database to store the data.'],
    },
    {
        title: 'What hardware i need for VOS server?',
        description: ["For a physical server, it's recommended to have a CPU of Intel Xeon E5 Series (or higher, at least 2.1 GHz) with 2 processors, 8 GB of memory or more, and a hard disk setup of a 50 GB system disk plus a data disk of 1 TB or higher (10K RPM or 120 MB/s). The operating system should be a minimal installation, preferably Red Hat Enterprise Linux Server release 6.5 to 7.4 (64-bit) or CentOS release 6.5 to 7.4 (64-bit), avoiding the xen kernel version (e.g., kernel 2.6.18-194xen).",
            "For Aliyun ECS, configurations depend on the number of simultaneous calls: for less than 2,000 calls, 4 cores and 4 GB memory are sufficient; for 2,000 or more, 8 cores and 8 GB memory are recommended, with an efficient cloud disk of 50 GB for the system and at least 200 GB for data. The recommended OS for Aliyun ECS is CentOS 6.10 64-bit."],
    },
]


// worth or not
export const VosWorth = [
    {
        id: 1,
        icon: React.createElement(FaServer),
        number: "4523+",
        content: 'Installation provided third party server'
    },
    {
        id: 2,
        icon: React.createElement(BsCloudArrowUpFill),
        number: "650+",
        content: 'Hosted solution provided'
    },
    {
        id: 3,
        icon: React.createElement(FaRegFlag),
        number: "35+",
        content: 'Countries we served'
    },
]