type SoftwareDevelopmentType = {
    id: number;
    imgSrc: string;
    title: string;
    description?: string[];
    featuresTitle?: string;
    featuresDescription?: string;
    features?: string[];
    bottomDescription?: string[];
}

type SmallPricingType = {
    title: string;
    price: number;
    description?: string[];
    featuresList: {
        feature: string;
        available: boolean;
    }[];
};

export const WebstieDevelopmentData: SoftwareDevelopmentType[] = [
    {
        id: 0,
        imgSrc: '/images/Web-Design-and-Development-Services-in-Amaravati.png',
        title: 'Website Development',
        description: [
            'Web development is the work involved in developing a Web site for the Internet (World Wide Web) or an intranet (a private network). Web development can range from developing a simple single static page of plain text to complex web applications, electronic businesses, and social network services. A more comprehensive list of tasks to which Web development commonly refers, may include Web engineering, Web design, Web content development, client liaison, client-side/server-side scripting, Web server and network security configuration, and e-commerce development.',
            'Among Web professionals, "Web development" usually refers to the main non-design aspects of building Web sites: writing markup and coding. Web development may use content management systems (CMS) to make content changes easier and available with basic technical skills.',
        ]
    }
]

export const MoreAboutWebsiteDev: SoftwareDevelopmentType[] = [
    {
        id: 1,
        imgSrc: '/images/static-website-designing.jpg',
        title: 'Static Website Designing?',
        description: [
            "Technically speaking, static website designing is most suited for those that don't require often updates. Static web design is very useful source for those business beings that wish to generate personalize and unique web page."
        ]
    },
    {
        id: 2,
        imgSrc: '/images/responsive-web-design.jpg',
        title: 'Responsive Website Designing?',
        description: [
            "Responsive website design is the phrase used for a website that revolutionizes and acclimatizes its appearance for finest viewing on screens of all sizes such as screens of smart phones, desktop computer screens, laptops and tablets as well.",
            "Websites that are not finished with responsive touch do not settle in to diverse screens and as such can be tough to outlook and navigate on smaller handheld devices."
        ]
    },
    {
        id: 3,
        imgSrc: '/images/custom-web-design.jpg',
        title: 'Custom Website Designing?',
        description: [
            "Custom website design technology shoves boundaries and fulfills expectations. Along with so much of your time and vision invested into us, our technology experts provide that extra wow to captivate your targeted clients. With groundbreaking custom website designing we will make your site worth visiting. We help apparition of your life come true.",
            "Increasing the visits and stay of people, search engine optimization, targeting meticulous clients, etc should also be checked on while picking on a company Apart from the designing area, it is vital for the company to have expertise in the related fields that boost the overall business of the client, after all that is what matters at the end."
        ]
    },
    {
        id: 4,
        imgSrc: '/images/mobile-web-design.jpg',
        title: 'Mobile Website Designing?',
        description: [
            "Mobile webpage design is all about technically and proficiently crafting websites that commune efficiently. It helps discover how web content can be delivered to mobile devices. Screen of the mobile and desktop are widely different; however mobile web design has made things possible.",
            "Today, right from surfing any shopping site to bank transactions, people use mobile sites. Various factors need to take into deliberation before deciphering your decision on picking a design. Considering the usage of the mobile sites, the mobile website designs are made."
        ]
    },
    {
        id: 5,
        imgSrc: '/images/website-maintence.jpg',
        title: 'Website Maintenance?',
        description: [
            "Website maintenance is ought to have these days in order to stay up to date with the internet world and commune properly. If you deem you will be building regular alterations to your website, you can save money by getting into a website maintenance contract."
        ]
    },
    {
        id: 6,
        imgSrc: '/images/dynamic-web-designing.jpg',
        title: 'Dynamic Website Design?',
        description: [
            "Dynamic Website design can be uncomplicated or multifarious depending on the design and development needs of the customers. Today's websites are dynamic and ­­they constantly mend their content, persuade social sharing, by engaging the users constantly. There are ample of benefits of using dynamic website designs today, like one can add image, photos facts, data and other related information regardless of any technical help.",
            "Today, social media and social engagement has taken the world over so why not we? Dynamic website gets integrated with the social media, which helps the users and visitors to share the content of the website on social sites that are booming today like, facebook, twitter, linkedin, instagram, etc."
        ]
    },
    {
        id: 7,
        imgSrc: '/images/ecommerce-web-design.jpg',
        title: 'Ecommerce Website Designing?',
        description: [
            "PULSE TALK GLOBAL ensures that you get highly functional website and that too in your budget. We work with customer centric approach and provide you web solution as per your business needs. We power our websites with advanced technology so that you don’t find any problem in managing the content. Moreover, we offer highly functional websites which ensures high conversion rate of your visitors.",
            "The evolution in the field of Technology has changed the preferences of the people. People of present era are much interested in online shopping. With this, every merchant, whether big or small, is keen in taking his/ her business live. The concept of online shop not only helps in getting new buyers but also new markets to sell the products. But for this, all you need is an interactive website. SAM Web Studio ensures that you get the website of your dream to accelerate the growth of your business."
        ]
    },
    {
        id: 8,
        imgSrc: '/images/Corporate-Web-Designing.jpg',
        title: 'Corporate Web Designing?',
        description: [
            "Corporate Website Designing exhibits a strong flair for style and interactivity of the company. Marvelous corporate websites draws you by exceptionally flouting through to clients and fascinating them to hang about. Corporate web designing provides entire information about the company and the products it deals with. It opens the full screen up to utilize as canvas for their merchandise.",
        ]
    },
    {
        id: 9,
        imgSrc: '/images/6726756_previewoffer.png',
        title: 'We offer a wide variety of website design services',
        features: [
            "Personal website and blog",
            "Brochure (web page landing)",
            "Corporate",
            "E-commerce websites",
            "instructive",
            "Web portal",
            "Catalog",
            "Magazine websites",
            "Social media websites",
            "Community building website (forum, social, shared website)",
        ]
    },
]

export const CostSoftwareDevelopment: SoftwareDevelopmentType[] = [
    {
        id: 1,
        imgSrc: '/images/software-development-costs.png',
        title: 'Factors that Determine the Website Development Cost?',
        description: [
            "Some of the significant factors that determine the average cost to build a custom website include:."
        ],
        features: [
            "Factors by types and purpose",
            "Factors by phases",
            "Essential factors",
        ]
    }
]

export const Pricing: SmallPricingType[] = [
    {
        title: 'Basic',
        price: 149,
        featuresList: [
            {
                feature: "Responsive Website",
                available: true
            },
            {
                feature: "Mobile Friendly",
                available: true
            },
            {
                feature: "Customer Support 24/7",
                available: true
            },
            {
                feature: "Dashbord + SIX Menu",
                available: true
            },
            {
                feature: "Webmail Support",
                available: false
            },
            {
                feature: "Domain Name Free 1 Year",
                available: false
            },
            {
                feature: "Hosting Free 1 Year",
                available: false
            },
            {
                feature: "6 Month Free Digital Marketing",
                available: false
            },
        ]
    },
    {
        title: 'Standerd',
        price: 299,
        featuresList: [
            {
                feature: "Responsive Website",
                available: true
            },
            {
                feature: "Mobile Friendly",
                available: true
            },
            {
                feature: "Customer Support 24/7",
                available: true
            },
            {
                feature: "Dashbord + SIX Menu",
                available: true
            },
            {
                feature: "Webmail Support",
                available: true
            },
            {
                feature: "Domain Name Free 1 Year",
                available: true
            },
            {
                feature: "Hosting Free 1 Year",
                available: true
            },
            {
                feature: "6 Month Free Digital Marketing",
                available: false
            },
        ]
    },
    {
        title: 'Premium',
        price: 599,
        featuresList: [
            {
                feature: "Responsive Website",
                available: true
            },
            {
                feature: "Mobile Friendly",
                available: true
            },
            {
                feature: "Customer Support 24/7",
                available: true
            },
            {
                feature: "Dashbord + SIX Menu",
                available: true
            },
            {
                feature: "Webmail Support",
                available: true
            },
            {
                feature: "Domain Name Free 1 Year",
                available: true
            },
            {
                feature: "Hosting Free 1 Year",
                available: true
            },
            {
                feature: "6 Month Free Digital Marketing",
                available: true
            },
        ]
    },
]