import * as React from "react";
import { FaGlobeAmericas, FaServer, FaShieldAlt, FaShieldVirus, FaRocket } from "react-icons/fa";
import { Ri24HoursFill } from "react-icons/ri";
import { AiOutlineBars } from "react-icons/ai";
import { IoSpeedometerOutline } from "react-icons/io5";
import { GiRocketFlight } from "react-icons/gi";

interface Feature {
    logo: React.ReactNode;
    title: string;
    description: string;
}

export const features: Feature[] = [
    {
        logo: React.createElement(FaGlobeAmericas),
        title: 'Perfect Hosting',
        description: 'Experience flawless hosting with unparalleled reliability and cutting-edge technology, ensuring your site is always live and secure.',
    },
    {
        logo: React.createElement(Ri24HoursFill),
        title: '24/7 Support',
        description: 'Our dedicated support team is available around the clock to assist you with any issues, ensuring your operations run smoothly without interruption.',
    },
    {
        logo: React.createElement(IoSpeedometerOutline),
        title: 'Powerful Performance',
        description: 'Harness the power of high-performance servers optimized to handle the most demanding workloads with ease and speed.',
    },
    {
        logo: React.createElement(FaServer),
        title: 'Super Server',
        description: 'Utilize our super servers for maximum efficiency, offering robust capabilities and unparalleled uptime to meet your growing business needs.',
    },
    {
        logo: React.createElement(AiOutlineBars),
        title: 'Modern Panel',
        description: 'Manage your hosting with ease using our intuitive, user-friendly panel designed for both beginners and advanced users.',
    },
    {
        logo: React.createElement(GiRocketFlight),
        title: 'Faster than Anyone',
        description: 'Outpace the competition with lightning-fast speeds, ensuring your website loads quickly and efficiently for all visitors.',
    },
];


// technology
export const technology: Feature[] = [
    {
        logo: React.createElement(FaShieldAlt),
        title: 'Maximum Protection',
        description: 'Safeguard your online presence with our cutting-edge security measures that protect against threats and ensure uninterrupted service.',
    },
    {
        logo: React.createElement(FaShieldVirus),
        title: 'Blazing Fast Performance',
        description: 'Experience unparalleled speed and responsiveness, making sure your website is always ready to handle heavy traffic with ease.',
    },
    {
        logo: React.createElement(FaRocket),
        title: 'Unmatched Reliability',
        description: 'Our robust infrastructure guarantees maximum uptime, providing a stable and reliable service that your business can depend on.',
    },
];

// pricing
type PricingType = {
    type: string;
    price: string;
    description: string;
    features: string[];
    button: string;
    buttonLink: string
}

export const pricingData: PricingType[] = [
    {
        type: "Student Plan",
        price: "₹9.99",
        description: "Perfect for students and small projects.",
        features: ["Unlimited SSD Space",
            "100.000 Inodes",
            "Unlimited Bandwidth",
            "99.99% Uptime",
            "Singapore Server",
            "CMS Ready"
        ],
        button: "Get Started",
        buttonLink: "/student-plan",
    },
    {
        type: "Adult Plan",
        price: "₹9.99",
        description: "Perfect for students and small projects.",
        features: ["Unlimited SSD Space",
            "100.000 Inodes",
            "Unlimited Bandwidth",
            "99.99% Uptime",
            "Singapore Server",
            "CMS Ready"
        ],
        button: "Get Started",
        buttonLink: "/student-plan",
    },
    {
        type: "Professional Plan",
        price: "₹9.99",
        description: "Perfect for students and small projects.",
        features: ["Unlimited SSD Space",
            "100.000 Inodes",
            "Unlimited Bandwidth",
            "99.99% Uptime",
            "Singapore Server",
            "CMS Ready"
        ],
        button: "Get Started",
        buttonLink: "/student-plan",
    },
]
